#include "MCP3424.h"

extern Serial pc;

MCP3424::MCP3424(PinName sda, PinName scl) : mcp3424_i2c(sda, scl)
{
    mcp3424_i2c.frequency(MCP3424_FREQ);
}

MCP3424::~MCP3424(){

}

bool MCP3424::Config(uint8_t channel, uint8_t resolution, bool mode, uint8_t PGA)
{
    bool ok = false;
    char addr = 0x00;
    if(mcp3424_i2c.write(MCP3424_ADDR, &addr, 1) != 0)
        return 0;
        
    _PGA = PGA;
    _mode = mode;
    
    if(resolution != 12 && resolution != 14 && resolution != 16 && resolution != 18)
    {
        _resolution = 12;
    } 
    else _resolution = resolution;
    
    _cfgbyte =  0;
    _cfgbyte =  _cfgbyte<<2;
    _cfgbyte |= (channel-1);
    _cfgbyte =  _cfgbyte<<1;
    _cfgbyte |= _mode;
    _cfgbyte =  _cfgbyte<<2;
    _cfgbyte |= int((_resolution-12)/2);
    _cfgbyte =  _cfgbyte<<2;
    _cfgbyte |= 0x00;
    
    char _send = (char)_cfgbyte;
    
    if(mcp3424_i2c.write(MCP3424_ADDR, &_send, 1) ==0)
    {
        ok = true;
    }
    else 
    {
        ok = false;
    }
    return ok;
}

bool MCP3424::NewConversion()
{
    char _send = (char)(_cfgbyte |= 128);
    if(mcp3424_i2c.write(MCP3424_ADDR, &_send, 1) != 0)
        return 0;
    else return 1;
}

bool MCP3424::IsConversionFinished()
{
    if(_resolution!=18)
    {
        _RequestedByte = 3;    
    } 
    else _RequestedByte = 4;
    
    
    if(mcp3424_i2c.read(MCP3424_ADDR, _recvBuff, _RequestedByte)!= 0) return 0;
    
    for(_i = 0; _i < _RequestedByte; _i++)
    {
        _Buffer[_i] = _recvBuff[_i];
    }

    _testvariable = _Buffer[_RequestedByte-1]>>7;
    
    return _testvariable;
}


long MCP3424::Measure()
{
    _resultat=0;
    
    while(IsConversionFinished()==1);
    
    switch (_resolution)
    {
        case 12:{
             _Buffer[0]&=0b00001111;
             _resultat = _Buffer[0]*256 + _Buffer[1];
    
            if(_resultat>2048-1) 
            {
                _resultat=_resultat-4096-1;
            }
        
            _resultat = _resultat*1000/_PGA;      
           
            break;
        }
        case 14:{
            _Buffer[0]&=0b00111111;
            _resultat = _Buffer[0]*256 + _Buffer[1];
    
            if(_resultat>8192-1)
            {
                _resultat=_resultat-16384-1;
            }
    
            _resultat = _resultat*250/_PGA;  
                   
             break;
        }
        case 16:{
            _resultat = _Buffer[0]*256 + _Buffer[1];
                        
            if(_resultat>32768-1) 
            {
                _resultat=_resultat-65536-1;
            }
            
            _resultat = _resultat*62.5/_PGA;   
            
             break;
      }
        case 18:{
             _Buffer[0]&=0b00000011;
            _resultat = _Buffer[0]*512 + _Buffer[1]*256 + _Buffer[2];
             
            if(_resultat>131072-1) 
            {
                _resultat=_resultat-262144-1;
            }
            
            _resultat = _resultat*15.625/_PGA; 
            
            break;
        }
    }
    return _resultat;
    
}