#ifndef _ROS_dombabot_hardware_interface_HardwareCommand_h
#define _ROS_dombabot_hardware_interface_HardwareCommand_h

#include <stdint.h>
#include <string.h>
#include <stdlib.h>
#include "ros/msg.h"
#include "std_msgs/Header.h"
#include "dombabot_hardware_interface/LegJointCommand.h"

namespace dombabot_hardware_interface
{

  class HardwareCommand : public ros::Msg
  {
    public:
      typedef std_msgs::Header _header_type;
      _header_type header;
      typedef dombabot_hardware_interface::LegJointCommand _front_left_leg_type;
      _front_left_leg_type front_left_leg;
      typedef dombabot_hardware_interface::LegJointCommand _back_left_leg_type;
      _back_left_leg_type back_left_leg;
      typedef dombabot_hardware_interface::LegJointCommand _front_right_leg_type;
      _front_right_leg_type front_right_leg;
      typedef dombabot_hardware_interface::LegJointCommand _back_right_leg_type;
      _back_right_leg_type back_right_leg;

    HardwareCommand():
      header(),
      front_left_leg(),
      back_left_leg(),
      front_right_leg(),
      back_right_leg()
    {
    }

    virtual int serialize(unsigned char *outbuffer) const
    {
      int offset = 0;
      offset += this->header.serialize(outbuffer + offset);
      offset += this->front_left_leg.serialize(outbuffer + offset);
      offset += this->back_left_leg.serialize(outbuffer + offset);
      offset += this->front_right_leg.serialize(outbuffer + offset);
      offset += this->back_right_leg.serialize(outbuffer + offset);
      return offset;
    }

    virtual int deserialize(unsigned char *inbuffer)
    {
      int offset = 0;
      offset += this->header.deserialize(inbuffer + offset);
      offset += this->front_left_leg.deserialize(inbuffer + offset);
      offset += this->back_left_leg.deserialize(inbuffer + offset);
      offset += this->front_right_leg.deserialize(inbuffer + offset);
      offset += this->back_right_leg.deserialize(inbuffer + offset);
     return offset;
    }

    const char * getType(){ return "dombabot_hardware_interface/HardwareCommand"; };
    const char * getMD5(){ return "cbc6a08cbd91491a5cc8f16291f5ccda"; };

  };

}
#endif
