#ifndef _ROS_dombabot_hardware_interface_LegJointState_h
#define _ROS_dombabot_hardware_interface_LegJointState_h

#include <stdint.h>
#include <string.h>
#include <stdlib.h>
#include "ros/msg.h"
#include "std_msgs/Float32.h"

namespace dombabot_hardware_interface
{

  class LegJointState : public ros::Msg
  {
    public:
      typedef std_msgs::Float32 _joint_1_orientation_type;
      _joint_1_orientation_type joint_1_orientation;
      typedef std_msgs::Float32 _joint_2_orientation_type;
      _joint_2_orientation_type joint_2_orientation;
      typedef std_msgs::Float32 _joint_3_orientation_type;
      _joint_3_orientation_type joint_3_orientation;
      typedef std_msgs::Float32 _joint_1_current_type;
      _joint_1_current_type joint_1_current;
      typedef std_msgs::Float32 _joint_2_current_type;
      _joint_2_current_type joint_2_current;
      typedef std_msgs::Float32 _joint_3_current_type;
      _joint_3_current_type joint_3_current;

    LegJointState():
      joint_1_orientation(),
      joint_2_orientation(),
      joint_3_orientation(),
      joint_1_current(),
      joint_2_current(),
      joint_3_current()
    {
    }

    virtual int serialize(unsigned char *outbuffer) const
    {
      int offset = 0;
      offset += this->joint_1_orientation.serialize(outbuffer + offset);
      offset += this->joint_2_orientation.serialize(outbuffer + offset);
      offset += this->joint_3_orientation.serialize(outbuffer + offset);
      offset += this->joint_1_current.serialize(outbuffer + offset);
      offset += this->joint_2_current.serialize(outbuffer + offset);
      offset += this->joint_3_current.serialize(outbuffer + offset);
      return offset;
    }

    virtual int deserialize(unsigned char *inbuffer)
    {
      int offset = 0;
      offset += this->joint_1_orientation.deserialize(inbuffer + offset);
      offset += this->joint_2_orientation.deserialize(inbuffer + offset);
      offset += this->joint_3_orientation.deserialize(inbuffer + offset);
      offset += this->joint_1_current.deserialize(inbuffer + offset);
      offset += this->joint_2_current.deserialize(inbuffer + offset);
      offset += this->joint_3_current.deserialize(inbuffer + offset);
     return offset;
    }

    const char * getType(){ return "dombabot_hardware_interface/LegJointState"; };
    const char * getMD5(){ return "497d5c9f7001ce048604e9948222b96f"; };

  };

}
#endif
