#include "mbed.h"


AnalogIn temp(A1);
Serial pc(USBTX,USBRX);
DigitalOut LED(D0);

int main()
{
    float tempC, tempF;

    while(1) {
        //conversion to degrees C - from sensor output voltage 
        float tempout=temp.read();
        pc.printf("analog value of temperature sensor is %f: ",tempout);

        tempC = ((tempout*3.3)-0.600)*100.0;
        //convert to degrees F
        tempF = (9.0*tempC)/5.0 + 32.0;
        //print the temp
        printf("%5.2F C %5.2F F \n\r", tempC, tempF);
        wait(0.5);
        
        if(tempC>35.30)
        {
            LED=1;
            wait(1);
            LED=0;
            }
            else
            LED=0;
    }
}