#ifndef __HCSR04_H__
#define __HCSR04_H__

#include "mbed.h"

#define TRIGGER_TIME 10 //us
#define MAX_RANGE 400 //cm


class HCSR04{
public:
    HCSR04(PinName pin_trigger, PinName pin_echo, float &container_var);
    void start_measurement(void);
    float* range_storage;
    
private:
    long unsigned int time_0, time_f;
    Ticker controller;
    Timer time_keeper;
    DigitalOut caller;
    InterruptIn listener;
    
    void stop_calling();
    void start_counting();
    void stop_counting();
};  

#endif /* __HCSR04_H__ */