#include "mbed.h"
#include "HCSR04.h"

HCSR04::HCSR04(PinName pin_trigger, PinName pin_echo, float &container_var):
caller(pin_trigger),
listener(pin_echo){
    range_storage = &container_var; //check how it's done
    listener.rise(this, &HCSR04::start_counting);
    listener.fall(this, &HCSR04::stop_counting);
    time_keeper.start();    
}

void HCSR04::start_measurement(void){
    caller = 1;
    controller.attach_us(this, &HCSR04::stop_calling, TRIGGER_TIME);    
}
    
void HCSR04::stop_calling(void){
    caller = 0;
    controller.detach();   
}

void HCSR04::start_counting(void){
    time_keeper.reset();   
}

void HCSR04::stop_counting(void){
    float temp_range  = (float)time_keeper.read_us()/58.0f; //convert to centimeters
    if (temp_range < MAX_RANGE)
        *range_storage = temp_range;
    else
        *range_storage = -1.0;
}