#include "mbed.h"
//Program to 'sweep' test a 'standard RC type servo
//Define some parameters using compiler directive '#define'
//Check Servo DATA if 0.75ms to 2.25ms then use min=750 and max=2250
//NB be values in microseconds (Following are generic values)
#define MID         1500
#define MIN         1000  
#define MAX         2350
#define STEP         50
//Time delay between steps in milliseconds
#define TIME         100000
 
PwmOut myServo(PB_2);
 
DigitalIn user_button(PC_13);
int counter_stoppen;
int counter_user_button;
float pos_servo;
int main() {
    
    while(1){
    if ((user_button.read() == 0) & (counter_stoppen == 0)) {
        counter_user_button++;
        counter_stoppen = 1;
    }
	if (user_button.read()){
        counter_stoppen = 0;
    }
    /*if (counter_user_button >= 5){
        counter_user_button = 1;
    }*/
    if (counter_user_button >= 5){
        counter_user_button = 1;
    }

    myServo.period_ms(20);
    myServo.pulsewidth_us(MID); //NB in microseconds

    switch (counter_user_button){
        case 1:
        myServo.pulsewidth_us(2350);
        pos_servo = 0.0;
        break;
        case 2:
            myServo.pulsewidth_us(500);
            pos_servo = 500.0;
        break;
        case 3:
            myServo.pulsewidth_us(1000);
            pos_servo = 1000.0;
        break;
        case 4:
            myServo.pulsewidth_us(1500);
            pos_servo = 1500.0;
        break;
    }

    printf("counter %d, pos %f\n",counter_user_button, pos_servo);
    /*myServo.period_ms(20);
    myServo.pulsewidth_us(MID); //NB in microseconds
 
    while(true) {
        for (int i=MIN;i<=MAX;i+=STEP){
            myServo.pulsewidth_us(i);
            wait_us(TIME);
        }
        for (int i=MAX;i>=MIN;i-=STEP){
            myServo.pulsewidth_us(i);
            wait_us(TIME);
        }
 
    }*/
    }
}