//GrannyStepper
#include "mbed.h"
#include "PM2_Libary.h"
#include <cstdio>
#include <iostream>
#include <functional>

using namespace std;

#define MID         1500
#define MIN         1000
#define MAX         2350
#define STEP         50
//Time delay between steps in milliseconds
#define TIME         100000

//inputs

    AnalogIn ir_analog_in_front(PC_2);  // define analog input ir sensor front pin PC_2
    AnalogIn ir_analog_in_back(PC_3);   // define analog input ir sensor back pin PC_3

    DigitalIn endswitch_step(PC_6);         // define digital input endswitch step pin PC_6
    DigitalIn endswitch_spindle_f(PB_12);    // define digital input endswitch spindle front pin PB_2 
    DigitalIn endswitch_spindle_b(PC_8);     // define digital input endswitch spindle back pin PC_8



    // goal of distance front 51mm - 14mm + 100mm + 10mm = 147mm = aprox 830 mV / 0.83 V
    // goal of distance back XX mm - 14mm + 100mm + 10mm = X mm = aprox XXX mV / X.XX V
    // 37mm = 3-3.1V

    float ir_front_mV = ir_analog_in_front.read() / 1000;   //define variable to help function
    float ir_back_mV = ir_analog_in_back.read() / 1000;     //define variable to help function

    //outputs
    //motors
    DigitalOut enable_motors_main(PA_10);
    DigitalOut enable_motors_spindle_front(PA_9);
    DigitalOut enable_motors_spindle_ba(PB_13);

    EncoderCounter  encoder_Move(PA_0, PA_1); // create encoder objects to read in the encoder counter values !pins fehlen!
    EncoderCounter  encoder_Front_Spindle(PB_6, PB_7);
    EncoderCounter  encoder_Back_Spindle(PA_6, PC_7);

    float   pwm_period_s = 0.00005f;    //PWM-Periode für DC-Motoren definiert

    FastPWM pwm_Move(PA_10);              
    FastPWM pwm_FrontSpindle(PA_9);               
    FastPWM pwm_BackSpindle(PB_13);            

    // create SpeedController and PositionController objects, default parametrization is for 78.125:1 gear box
    float max_voltage = 12.0f;                  // define maximum voltage of battery packs, adjust this to 6.0f V if you only use one batterypack
    float counts_per_turn = 20.0f * 78.125f;    // define counts per turn at gearbox end: counts/turn * gearratio
    float kn = 180.0f / 12.0f;                  // define motor constant in rpm per V
    float k_gear = 100.0f / 78.125f;            // define additional ratio in case you are using a dc motor with a different gear box, e.g. 100:1
    float kp = 0.1f;                            // define custom kp, this is the default speed controller gain for gear box 78.125:1

    PositionController positionController_Move(counts_per_turn * k_gear, kn / k_gear, kp * k_gear, max_voltage, pwm_Move, encoder_Move);
    //PositionController positionController_Front_Spindle(counts_per_turn * k_gear, kn / k_gear, kp * k_gear, max_voltage, pwm_FrontSpindle, encoder_Front_Spindle);
    //PositionController positionController_Back_Spindle(counts_per_turn * k_gear, kn / k_gear, kp * k_gear, max_voltage, pwm_BackSpindle, encoder_Back_Spindle);
    

    float max_speed_rps = 0.5f;                 // define maximum speed that the position controller is changig the speed, has to be smaller or equal to kn * max_voltage

    //servo
    //Servo servo_offshoot(PB_12);
    float servo_offshoot_angle = 0;
    int servo_period_mus = 20000;
    PwmOut servo_offshoot(PB_2); 

    //Eingänge
    InterruptIn user_button(PC_13);

    //Variables for movement functions
    //bool drive_condition;
    //bool spindle_front_up;
    //bool spindle_front_down;
    //bool spindle_back_up;
    //bool spindle_back_down;
    //bool offshoot_in_condition;
    //bool offshoot_out_condition;
    //bool no_sense;
    //bool start_s;
    float stop_move;
    float stop_spindle_front;
    float stop_spindle_back;
    float pos_move;
    float pos_spindle_front;
    float pos_spindle_back;
    float drive_move;
    float drive_nosense_move;
    float drive_spindle_front;
    float drive_spindle_back;
    int servo_position;         //nach ausprobieren anpassen und in servo funktion als rückgabe wert definieren
    
    

// while loop gets executed every main_task_period_ms milliseconds
int main_task_period_ms = 50;   // define main task period time in ms e.g. 50 ms -> main task runns 20 times per second
Timer main_task_timer;          // create Timer object which we use to run the main task every main task period time in ms

//servo
int servo_counter = 0; 
int loops_per_seconds = static_cast<int>(ceilf(1.0f/(0.001f*(float)main_task_period_ms)));

//functions
    //Space
    //inputs
bool ir_front(){                        //function to check if desired goal in height is reached
    if(ir_front_mV <= 830.0f){
        return true;
    }else{
        return false;
    }
}

bool ir_front_end(){
     if(ir_front_mV <= 830.0f){
        return true;
    }else{
        return false;
    }
}

bool ir_back(){                      //function to check if desired goal in height is reached
      if(ir_back_mV <= 830.0f){
        return true;
    }else{
        return false;
    }
}

bool end_step(){                        //function to check if next step is reached open switch
    if(endswitch_step.read()){             //define pullup mode!!
    return false;
    }else{
        return true;
    }
}

bool end_spindel_f(){                   //function to check if front spindle is in position 0
    if(endswitch_spindle_f.read()){
        return true;
    }else{
        return false;
    }
}

bool end_spindel_b(){                   //function to check if back spindle is in position 0
    if(endswitch_spindle_b.read()){
        return true;
    }else{
        return false;
    }
}
bool offshoot_status_in(){                 //if offshoot is in, returns true
    if(servo_position == 930){
        return true;
        }else{
            return false;
        }
    
}

bool offshoot_status_out(){                 //if offshoot is out, returns true
    if(servo_position == 450){
        return true;
        }else{
            return false;
        }
}

    //movements
void drive(bool drive_condition){                                                 //function to drive forward until next step is reached
    if(drive_condition == true){
        drive_move = positionController_Move.getRotation() - 10.0f;
        positionController_Move.setDesiredRotation(drive_move, max_speed_rps);
    };
    if(drive_condition==false){
        pos_move = positionController_Move.getRotation();
        positionController_Move.setDesiredRotation(pos_move, max_speed_rps);
    };
}

void drive_nosense(bool no_sense){                                                  //function to drive without sensors
    if(no_sense == true){
        drive_nosense_move = positionController_Move.getRotation() - 3.0f;
        positionController_Move.setDesiredRotation(drive_nosense_move, max_speed_rps);
    };
    if (no_sense == false) {
        pos_move = positionController_Move.getRotation();
        positionController_Move.setDesiredRotation(pos_move, max_speed_rps);
    };                                                         //werte anpassen, motorsteuerungsvariante anpassen
        
}

void spindle_up_front(bool spindle_front_up){                                            //function to move spindles up as soon as step is reached and until desired goal in height is hit
    if(spindle_front_up == true){
        pwm_FrontSpindle.write(0.25f);
    };
    
}

void spindle_up_back(bool spindle_back_up){                                            //function to move spindles up as soon as step is reached and until desired goal in height is hit
    if(spindle_back_up == true){                                                 
        pwm_BackSpindle.write(0.25f);
    };
}

void spindle_down_front(bool spindle_front_down){                                          //function to move spindles down until endswitches of spindles show true
    if(spindle_front_down == true){                                                //reverse Motor drive direction
        pwm_FrontSpindle.write(0.75f);
    };
}

void spindle_down_back(bool spindle_back_down){                                        //function to move spindles down until endswitches of spindles show true
    if(spindle_back_down == true){                                                 //reverse Motor drive direction
        pwm_BackSpindle.write(0.75f);
    };
}

float offshoot_out(bool offshoot_out_condition){
    if(offshoot_out_condition == true){
        servo_offshoot.pulsewidth_us(450);
    }
    servo_position = servo_offshoot.read_pulsewitdth_us();
    return servo_position;
}

float offshoot_in(bool offshoot_in_condition){
    if(offshoot_in_condition == true){
        servo_offshoot.pulsewidth_us(930);
    }
    servo_position = servo_offshoot.read_pulsewitdth_us();
    return servo_position;
}

void start_stop(bool start_s){
    //move spindles to endstop 
    //then move spindles, position controlled to designated destination
    if(end_spindel_f() == false && end_spindel_b() == false){
        spindle_up_back(true);
        spindle_up_front(true);
    };
    if(end_spindel_f() && end_spindel_b()){
        //positionController_Front_Spindle.setDesiredRotation(0.0f, max_speed_rps);
        //positionController_Back_Spindle.setDesiredRotation(0.0f, max_speed_rps);
    };
}; 

int main(){
    //PullUp Mode for Endswitch
    endswitch_step.mode(PullDown);
    endswitch_spindle_f.mode(PullDown);
    endswitch_spindle_b.mode(PullDown);

    //Initialising Motors
    pwm_FrontSpindle.period(pwm_period_s);
    pwm_BackSpindle.period(pwm_period_s);
    pwm_FrontSpindle.write(0.5f);
    pwm_BackSpindle.write(0.5f);
    //initialising servo
    servo_offshoot.pulsewidth_us(930);
    
    
    //Variables for Counter and Switches
    bool start, stopp, reset;
	int counter_start, counter_reset;
    int counter_user_button, counter_stoppen;
    bool drive_down;

while(true){
		
		//Counter für Start Stopp Reset
		if ((user_button.read() == 1) & (counter_stoppen == 0)) {
	        counter_user_button++;
	        counter_stoppen = 1;
	
	    }
		if (user_button.read() == 0){
	        counter_stoppen = 0;
	    }
	    if (counter_user_button >= 4){
	        counter_user_button = 0;
	    }
    
	    switch(counter_user_button){
	    	case 0:
	    		start = 0;
	    		stopp = 0;
	    		reset = 0;
	    		drive_down = 0;
	    	break;
			case 1:
	    		start = 1;
	    		stopp = 0;
	    		reset = 0;
	    	break;
	    	case 2:
	    		start = 0;
	    		stopp = 1;
	    		reset = 0;
	    	break;
	    	case 3:
	    		start = 0;
	    		stopp = 0;
	    		reset = 1;
	    	break;
		} 
        
    
		
		//Startbedingungen für Schlaufen
		if(start == 1) counter_start = 1;
		if(reset == 1) counter_reset = 1;
		if(start == 0) counter_start = 0;
		if(reset == 0) counter_reset = 0;

        cout<<"counter_start: "<<counter_start;
        cout<<"counter_user_button "<<counter_user_button;
        cout<<"drive down: "<<drive_down;
        cout<<"counter_reset "<<counter_reset;
        cout<<"stop "<<stopp;      
        cout<<endl;
        counter_start = 1;
    
	
		switch(counter_start){
			case 1: //Roboter nach vorne fahren
                servo_offshoot.pulsewidth_us(930);
                if(end_step() != 1){ 
                    drive_move = positionController_Move.getRotation() - 10.0f;
                    positionController_Move.setDesiredRotation(drive_move, max_speed_rps);
                //drive(true);
                    };

                if(end_step()){
                    pos_move = positionController_Move.getRotation();
                    positionController_Move.setDesiredRotation(pos_move, max_speed_rps);
                    //drive(false);
                    counter_start++;
                };
                
                if (ir_front_end()){
                    pos_move = positionController_Move.getRotation();
                    positionController_Move.setDesiredRotation(pos_move, max_speed_rps);
					//drive(false);
						counter_start = 0;
						//drive_down = 1; // Wenn nicht runtergefahren wird, kann man diese Variable zum rücksetzen des Startes verwenden
					};
                    //pos_spindle_back = positionController_Back_Spindle.getRotation();
                    //pos_spindle_front = positionController_Front_Spindle.getRotation();
			break;
			case 2: //Stelze vorne und hinten ausfahren
				if(end_spindel_b() != 1 && end_spindel_f() != 1){
                pwm_FrontSpindle.write(0.25f);
                pwm_BackSpindle.write(0.25f);
                
                //spindle_up_front(true);
				//spindle_up_back(true);
                };
				counter_start++;
			break;
			case 3: //Stelzen anhalten wenn die Höhe erreicht ist
				if (ir_front()){
                    pwm_FrontSpindle.write(0.5f);
					//spindle_up_front(false);
				}
				if ( ir_back()){
                    pwm_BackSpindle.write(0.5f);
					//spindle_up_back(false);
				}
				if (ir_back() && ir_front()){
                    pwm_BackSpindle.write(0.5f);
                    pwm_FrontSpindle.write(0.5f);
                    //spindle_up_back(false);
                    //spindle_up_front(false);
					counter_start++;
				}
			break;
			case 4: //Ableger ausfahren
				servo_offshoot.pulsewidth_us(450);
                //offshoot_out(true);
				/*if (offshoot_status_in() == false) { //abfrage ob ableger eingefahren ist
					offshoot_out(false);
					counter_start++;}*/
			break;
			case 5: //Stelzen vorne einfahren
				if(end_spindel_b() != 0){
                    pwm_FrontSpindle.write(0.75f);
                    //spindle_down_front(true);
                };
                if(end_spindel_b()){
                    pwm_FrontSpindle.write(0.5f);
                    //spindle_down_front(false);
                    counter_start++;
                }
			break;
			case 6: //nach vorne fahren, damit der Ableger ganz auf der nächsten Stufe ist
                //drive_nosense(true); //vorwärts fahren ohne sensorik
                drive_nosense_move = positionController_Move.getRotation() - 3.0f;
                positionController_Move.setDesiredRotation(drive_nosense_move, max_speed_rps);
				//noch nicht fertig
				//Muss Zeit- oder Positionsgesteuert werden
				counter_start++;
			break;
			case 7: //Stelzen hinten einfahren
                if(end_spindel_b() != 1){
                    pwm_BackSpindle.write(0.75f);
                    //spindle_up_back(true);
                };
				if (end_spindel_b()){
                    pwm_BackSpindle.write(0.5f);
					//spindle_up_back(false);
					counter_start++;
				}
			break;
			case 8: //Ableger wieder einfahren
                servo_offshoot.pulsewidth_us(930);
				if(offshoot_status_in() == false){
                    offshoot_in(true);
                };
				if (offshoot_status_in() == true){ //abfrage ob ableger eingefahren ist
					offshoot_in(false);
					counter_start = 1;
				};
			break;


	
	
		if (stopp == 1){  //Alle Aktionen werden gestoppt
			//drive(false); 
            //drive_nosense(false);
            pos_move = positionController_Move.getRotation();
            positionController_Move.setDesiredRotation(pos_move, max_speed_rps);
			//spindle_up_front(false);
            pwm_FrontSpindle.write(0.5f);
			//spindle_up_back(false);
            pwm_BackSpindle.write(0.5f);
			//spindle_down_front(false);
			//spindle_down_back(false);
			//offshoot_out(false);
            //servo_offshoot.pulsewidth_us(930);
			//offshoot_in(false);	
			//drive_down = 0;
		}
        

		switch (counter_reset){
			case 1:
                servo_offshoot.pulsewidth_us(930);
				counter_reset++;
			break;
			case 2:
				if (end_spindel_f() != 1) {
                    spindle_up_front(true);
                    pwm_FrontSpindle.write(0.25f);
                }
				if (end_spindel_f() == true){
				spindle_up_front(false);
				counter_reset++;
				}
			break;
			case 3:
				if (end_spindel_b() != true) spindle_up_back(true);
				if (end_spindel_b() == true){
				spindle_up_back(false);
				counter_reset = 0;
				}
			break;
		}
					
		
	}
}
}