#include "mbed.h"
#include "EthernetInterface.h"

#define ECHO_SERVER_PORT   7

DigitalOut heartbeatLed(LED_GREEN);
DigitalOut myled(LED_RED);

void server_thread(void const* arg) {
    
    TCPSocketServer server;
    
    server.set_blocking (true);
    server.bind(ECHO_SERVER_PORT);
    server.listen(1);    
    while (true) 
    {
        //printf("Wait for new connection...\r\n");
        TCPSocketConnection client;
        server.accept(client);
        client.set_blocking(false, true); // Timeout after (1.5)s
        
        //printf("Connection from: %s\r\n", client.get_address());
        char buffer[256];
        while (true) {
            int n = client.receive(buffer, sizeof(buffer));
            if (n <= 0) break;
            
            if(buffer[0]=='Y'){
                myled=1;
            }else{
                myled=0;
            }

            sprintf(buffer, "Hi Alisha.How are u?");
            client.send_all(buffer, n);
            if (n <= 0) break;
        }        
        client.close();
    }
}


int main (void) 
{
    
    //printf("Wait a second...\r\n");
    //uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x00, 0x01, 0x02}; 
    static const char*          mbedIp       = "192.168.64.232";  //IP
    static const char*          mbedMask     = "255.255.255.0";  // Mask
    static const char*          mbedGateway  = "192.168.64.1";    //Gateway
 
    EthernetInterface eth;
    eth.init(mbedIp, mbedMask, mbedGateway); //Use DHCP
    eth.connect();
    //printf("Server IP Address is %s\r\n", eth.getIPAddress());
    
    Thread server(&server_thread);
    
    while(true){
      Thread::wait(1000);
      // Heartbeat.
      // The board systematically crashes after a low number of sends from a client,
      // e.g. ~10 times 1000 bytes, ~2-3 times 10000 bytes, etc.
      heartbeatLed = !heartbeatLed;
    }   
    
}

