/*
 *  Copyright (c) 2012 Neal Horman - http://www.wanlink.com
 *  
 *  License: MIT open source (http://opensource.org/licenses/MIT)
 *      Summary;
 *      Use / modify / distribute / publish it how you want and 
 *      if you use it, or don't, you can't hold me liable for how
 *      it does or doesn't work.
 *      If it doesn't work how you want, don't use it, or change
 *      it so that it does work.
 */
 
#include "mbed.h"
#include "Adafruit_SSD1306.h"
 
DigitalOut myled(LED1);
 
// an SPI sub-class that provides a constructed default
class SPIPreInit : public SPI
{
public:
    SPIPreInit(PinName mosi, PinName miso, PinName clk) : SPI(mosi,miso,clk)
    {
        format(8,3);
        frequency(2000000);
    };
};
 
// an I2C sub-class that provides a constructed default
class I2CPreInit : public I2C
{
public:
    I2CPreInit(PinName sda, PinName scl) : I2C(sda, scl)
    {
        frequency(400000);
        start();
    };
};
 
SPIPreInit gSpi(PA_8,PA_7,PA_6);
Adafruit_SSD1306_Spi gOled1(gSpi,PC_6,PA_0,PA_5);
 
 
int main()
{   uint16_t x=0;
 
    gOled1.printf("%ux%u OLED Display\r\n", gOled1.width(), gOled1.height());
    
    while(1)
    {
        myled = !myled;
        gOled1.printf("%u\r",x);
        gOled1.display();
        x++;
        wait(1.0);
    }
}