#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include "TextLCD.h"
//CNN Tech News RSS Feed - get web page with XML
// displays titles on LCD  from XML "<title>....title text...</title>"
TextLCD lcd(p15, p16, p17, p18, p19, p20); // rs, e, d0-d3
EthernetNetIf eth;
HTTPClient http;
HTTPResult result;
PwmOut speaker(p21);
bool completed = false;
void request_callback(HTTPResult r)
{
    result = r;
    completed = true;
}

int main()
{
    //while(1) {
    char *tstartXML = "<title>"; //RSS XML start title
    char *tendXML ="</title>"; //RSS XML end title
    char *tsptr;
    char *teptr;
    int i=0,j=0,t=0,c=0,d=0;
    lcd.cls();
    lcd.printf("net setup");
    EthernetErr ethErr = eth.setup();
    if (ethErr) {
        lcd.printf("\n\r net error");
        return -1;
    }
    lcd.printf("\n\r net ok");
    HTTPStream stream;
    char BigBuf[2048 + 1] = {0};
    stream.readNext((byte*)BigBuf, 2048); //Point to buffer for the first read
    //CNN Tech News RSS Feed - get web page with XML
    HTTPResult r = http.get("http://alerts.weather.gov/cap/wwaatmget.php?x=GAC121&y=0", &stream, request_callback);
    while (!completed) {
        c=0;
        Net::poll(); // Polls the Networking stack
        if (stream.readable()) { // check for end of file
            BigBuf[stream.readLen()] = 0; // Transform this buffer in a zero-terminated char* string
            tsptr = BigBuf;
            // displays titles on LCD  from XML "<title>....title text...</title>"
            do {
                tsptr = strstr(tsptr,tstartXML); // find <title> in string - NULL if not
                teptr = strstr(tsptr,tendXML); // find <\title> in string - NULL if not
                if (tsptr!=NULL) tsptr = tsptr + strlen(tstartXML);// move to char after "<title>"
                if ((tsptr!=NULL)&&(teptr!=NULL)) {
                    i=0;
                    // loop to scroll characters slowly across LCD
                    for (j=0; (j+15)<(strlen(tsptr)-strlen(teptr)); j++) {
                        lcd.cls(); // clear screen before writing a new line
                        // loop to output a line on the LCD
                        for (i=0; ((i<16)&&(tsptr[i+j-1] != '<')); i++) {
                            c++;
                        }
                        i=0;
                        if (t>0 && c> 51 && d==0 && c!=108) {
                            speaker.period(1.0/500.0); // 500hz period
                            speaker =0.5; //50% duty cycle - max volume
                            wait(2.5);
                            speaker=0.0; // turn off audio
                            wait(1);
                            speaker =0.5; //50% duty cycle - max volume
                            wait(2.5);
                            speaker=0.0; // turn off audio
                            wait(1);
                            i=0;
                            d=1;
                        }
                        for (i=0; ((i<16)&&(tsptr[i+j-1] != '<')); i++) {
                            lcd.putc(tsptr[i+j]);
                        }
                        if (j==0) wait(1.2); //add first line delays for scroll timing
                        wait(.25); //delay for charcter scroll timing
                    }
                    wait(.4);
                    lcd.cls(); //clear LCD between news items
                    wait(.2);

                }

            } while (tsptr!=NULL); // No more "<title>"s in BigBuf to display
            stream.readNext((byte*)BigBuf, 2048); //Buffer has been read, now we can put more data in it
            c=0;
            t++;
        }
    }
    lcd.cls();
    if (result == HTTP_OK) {
        lcd.cls();
        lcd.printf(" Read complete\n\r");

    } else {
        lcd. printf(" Error %d\n", result);
        return -1;
    }
    // }
}
