#include "mbed.h"
#include "block.h"

Block::Block()
{
    int x=y=width=height=color=0;
}

Block::Block(int x, int y, int w, int h, int c)
    : x(x), y(y), width(w), height(h), color(c) {}

/*
 * Member Function move:
 * Description: Colors in the previous block black
 *  and moves block to new position.
 */
void Block::move(NokiaLCD &lcd, int increment)
{
    draw(lcd, true);
    y += increment;
}


/*
 * Member Function moveCPU:
 * Description: Colors in the previous block black
 *  and moves block to new position.
 *  inc variable allows block to only move every
 *  other function call.
 */
void Block::moveCPU(NokiaLCD &lcd, int _y)
{
    static int inc = 1;
    draw(lcd, true);
    if(_y>y+height/2 && y+height<130) y += inc;
    else if(_y+5<y+height/2 && y>0) y -= inc;
    inc = (inc) ? 0 : 1;
}

void Block::draw(NokiaLCD &lcd, bool isBlack) const
{
    lcd.fill(x, y, width, height, (isBlack) ? 0x000000 : color);
}

int Block::size() const
{
    return width*height;
}

int Block::getWidth() const
{
    return width;
}

int Block::getHeight() const
{
    return height;
}

int Block::getX() const
{
    return x;
}

int Block::getY() const
{
    return y;
}

