#include "mbed.h"
#include "paddle.h"

Paddle::Paddle() {
  int x=y=width=height=color=score=0;
  lives = 3;
}

Paddle::Paddle(int x, int y, int w, int h, int c, int l, int s)
 : x(x), y(y), width(w), height(h), color(c), lives(l), score(s) {}
 
/* 
 * Member Function move:
 * Description: Colors in the previous paddle black
 *  and moves paddle to new position.
 */
void Paddle::move(NokiaLCD &lcd, int increment) {
  draw(lcd, true);
  y += increment;
}


/* 
 * Member Function moveCPU:
 * Description: Colors in the previous paddle black
 *  and moves paddle to new position.
 *  inc variable allows paddle to only move every
 *  other function call.
 */
void Paddle::moveCPU(NokiaLCD &lcd, int _y) {
  static int inc = 1;
  draw(lcd, true);
  if(_y>y+height/2 && y+height<130) y += inc;
  else if(_y+5<y+height/2 && y>0) y -= inc;
  inc = (inc) ? 0 : 1;
}

void Paddle::draw(NokiaLCD &lcd, bool isBlack) const {
  lcd.fill(x, y, width, height, (isBlack) ? 0x000000 : color);
}

bool Paddle::loseLife() {
  return --lives;
}

void Paddle::addPoints(int p) {
  score=score+p;
}

int Paddle::size() const {
  return width*height;
}

int Paddle::getWidth() const {
  return width;
}

int Paddle::getHeight() const {
  return height;
}

int Paddle::getX() const {
  return x;
}

int Paddle::getY() const {
  return y;
}

int Paddle::getLives() const {
  return lives;
}

int Paddle::getScore() const {
  return score;
}

void Paddle::setLives(int l) {
  lives = l;
}
void Paddle::setScore(int s) {
  score = s;
}