#include "mbed.h"
#include "NokiaLCD.h"
#include "PS2Keyboard.h"
#include "ball.h"
#include "paddle.h"
#include "block.h"

// State enumerator
typedef enum {
    RESET1, RESET2, RUN, PAUSE, WIN
} STATES;

NokiaLCD lcd(p5, p7, p8, p9, NokiaLCD::LCD6610); // mosi, sclk, cs, rst, type

PS2Keyboard ps2kb(p12, p11); // CLK, DAT

DigitalIn sw2(p24);
DigitalIn sw1(p25);

PwmOut g(p21);
PwmOut b(p22);
PwmOut r(p23);

// Button enumerator for PS/2 keyboard
enum BUTTONS {
    UP = 0xe75,
    DOWN = 0xe72,
};

/*
 * Subroutine drawScreen:
 * Description: Draws paddle, blocks
 *  and the ball.
 */
void drawScreen(Paddle paddle1, Ball theBall, Block block1, Block block2, Block block3, Block block4,
                Block block5, Block block6, Block block7, Block block8, Block block9,
                Block block11, Block block12, Block block13, Block block14,
                Block block15, Block block16, Block block17, Block block18, Block block19, bool isBlack)
{
    paddle1.draw(lcd, isBlack);
    theBall.draw(lcd ,isBlack);
    block1.draw(lcd ,isBlack);
    block2.draw(lcd ,isBlack);
    block3.draw(lcd ,isBlack);
    block4.draw(lcd ,isBlack);
    block5.draw(lcd ,isBlack);
    block6.draw(lcd ,isBlack);
    block7.draw(lcd ,isBlack);
    block8.draw(lcd ,isBlack);
    block9.draw(lcd ,isBlack);
    block11.draw(lcd ,isBlack);
    block12.draw(lcd ,isBlack);
    block13.draw(lcd ,isBlack);
    block14.draw(lcd ,isBlack);
    block15.draw(lcd ,isBlack);
    block16.draw(lcd ,isBlack);
    block17.draw(lcd ,isBlack);
    block18.draw(lcd ,isBlack);
    block19.draw(lcd ,isBlack);
}

/*
 * Subroutine drawScores:
 * Description: Draws the scoreboard
 */
void drawScores(Paddle paddle1)
{
    lcd.locate(6.5,0);
    lcd.printf("%d",paddle1.getScore());
    lcd.locate(7.5,15);
    lcd.putc('0' + paddle1.getLives());
}

int main()
{
    PS2Keyboard::keyboard_event_t evt_kb; // Setup keyboard interrupt
    lcd.background(0x000000);
    lcd.cls();
    Paddle paddle1;
    Ball theBall;
    Block block1, block2, block3, block4, block5, block6, block7, block8, block9;
    Block block11, block12, block13, block14, block15, block16, block17, block18, block19;
    int temp, count=0;
    drawScreen(paddle1, theBall, block1, block2, block3, block4, block5, block6, block7, block8, block9,
               block11, block12, block13, block14, block15, block16, block17, block18, block19, false);
    drawScores(paddle1);
    STATES state = RESET1; // Initial state is RESET
    while(1) {
        switch(state) {
            case WIN: // When palyer gets max score
                lcd.locate(4,3);
                lcd.printf("YOU WON!");
                if(!sw2) { // Reset if SW2 is pressed
                    while(!sw2);
                    paddle1.setLives(3);
                    paddle1.setScore(0);
                    state = RESET1;
                    break;
                }
                break;
            case RESET1: // Reset objects, draw the screen, state = PAUSE
                lcd.cls();
                paddle1 = Paddle(1,45,5,25,0xFFFFFF,paddle1.getLives(),paddle1.getScore());
                theBall = Ball(6,57,5,5,0xFFFF00,1,1);
                block1 = Block(125,10,5,20,0x00FF00);
                block2 = Block(125,40,5,20,0xFF0000);
                block3 = Block(125,70,5,20,0xFFEE00);
                block4 = Block(125,100,5,20,0x00FFFF);                
                block5 = Block(113,5,5,20,0x00FF00);
                block6 = Block(113,30,5,20,0xFF0000);
                block7 = Block(113,55,5,20,0xFFFFFF);
                block8 = Block(113,80,5,20,0xFFEE00);
                block9 = Block(113,105,5,20,0x00FFFF);                
                block11 = Block(101,10,5,20,0xFF0000);
                block12 = Block(101,40,5,20,0x00FF00);
                block13 = Block(101,70,5,20,0x00FFFF);
                block14 = Block(101,100,5,20,0xFFEE00);           
                block15 = Block(89,5,5,20,0xFF0000);
                block16 = Block(89,30,5,20,0x00FF00);
                block17 = Block(89,55,5,20,0xFFFFFF);
                block18 = Block(89,80,5,20,0x00FFFF);
                block19 = Block(89,105,5,20,0xFFEE00);
                drawScreen(paddle1, theBall, block1, block2, block3, block4, block5, block6, block7, block8, block9,
                           block11, block12, block13, block14, block15, block16, block17, block18, block19, false);
                drawScores(paddle1);
                state = PAUSE;
                break;
            case RESET2: // Reset objects, draw the screen, state = PAUSE
                lcd.cls();
                paddle1 = Paddle(1,45,5,25,0xFFFFFF,paddle1.getLives(),paddle1.getScore());
                theBall = Ball(6,57,5,5,0xFFFF00,1,1);
                drawScreen(paddle1, theBall, block1, block2, block3, block4, block5, block6, block7, block8, block9,
                           block11, block12, block13, block14, block15, block16, block17, block18, block19, false);
                drawScores(paddle1);
                state = PAUSE;
                break;
            case PAUSE: // Set RGB LED to Red, wait for switch input
                r = 0;
                b = g = 1;
                if(!sw2) {
                    while(!sw2);
                    paddle1.setLives(3);
                    paddle1.setScore(0);
                    state = RESET1;
                    break;
                }
                if(!sw1) {
                    while(!sw1);
                    state = RUN;
                }
                break;
            case RUN: // Set RGB LED to Blue and run program
                r = g = 1;
                b = 0;
                if(!sw2) { // Reset if SW2 is pressed
                    while(!sw2);
                    paddle1.setLives(3);
                    paddle1.setScore(0);
                    state = RESET1;
                    break;
                }
                if(!sw1) { // Pause if SW1 is pressed
                    while(!sw1);
                    state = PAUSE;
                    break;
                }
                if (ps2kb.processing(&evt_kb)) { // Executes if a key is pressed
                    temp = evt_kb.scancode[0];
                    for (int i = 1; i < evt_kb.length; i++) { // Parse keyboard input into a key
                        temp <<= 4;
                        temp |= evt_kb.scancode[i];
                    }
                    switch(temp) { // Use key enumerator to move paddle1
                        case UP:
                            if(paddle1.getY()>2)
                                paddle1.move(lcd, -2);
                            break;
                        case DOWN:
                            if(paddle1.getY()+paddle1.getHeight()<128)
                                paddle1.move(lcd, 2);
                            break;
                    }


                }

                if(++count==3) { // Only move the ball once every 4 times through the loop
                    count = 0;
                    if(theBall.hitP1((paddle1.getX()+paddle1.getWidth()), paddle1.getY(), paddle1.getHeight()))
                        theBall.reverseX();
                    if(theBall.hitB1((block1.getX()+block1.getWidth()), block1.getY(), block1.getHeight())) {
                        theBall.reverseX();
                        paddle1.addPoints(25);
                        block1.move(lcd, -100);
                    }
                    if(theBall.hitB1((block2.getX()+block2.getWidth()), block2.getY(), block2.getHeight())) {
                        theBall.reverseX();
                        paddle1.addPoints(25);
                        block2.move(lcd, -100);
                    }
                    if(theBall.hitB1((block3.getX()+block3.getWidth()), block3.getY(), block3.getHeight())) {
                        theBall.reverseX();
                        paddle1.addPoints(25);
                        block3.move(lcd, -100);
                    }
                    if(theBall.hitB1((block4.getX()+block4.getWidth()), block4.getY(), block4.getHeight())) {
                        theBall.reverseX();
                        paddle1.addPoints(25);
                        block4.move(lcd, -200);
                    }
                    if(theBall.hitB1((block5.getX()+block5.getWidth()), block5.getY(), block5.getHeight())) {
                        theBall.reverseX();
                        paddle1.addPoints(20);
                        block5.move(lcd, -100);
                    }
                    if(theBall.hitB1((block6.getX()+block6.getWidth()), block6.getY(), block6.getHeight())) {
                        theBall.reverseX();
                        paddle1.addPoints(20);
                        block6.move(lcd, -100);
                    }
                    if(theBall.hitB1((block7.getX()+block7.getWidth()), block7.getY(), block7.getHeight())) {
                        theBall.reverseX();
                        paddle1.addPoints(20);
                        block7.move(lcd, -100);
                    }
                    if(theBall.hitB1((block8.getX()+block8.getWidth()), block8.getY(), block8.getHeight())) {
                        theBall.reverseX();
                        paddle1.addPoints(20);
                        block8.move(lcd, -200);
                    }
                    if(theBall.hitB1((block9.getX()+block9.getWidth()), block9.getY(), block9.getHeight())) {
                        theBall.reverseX();
                        paddle1.addPoints(20);
                        block9.move(lcd, -200);
                    }
                    if(theBall.hitB1((block11.getX()+block11.getWidth()), block11.getY(), block11.getHeight())) {
                        theBall.reverseX();
                        paddle1.addPoints(15);
                        block11.move(lcd, -100);
                    }
                    if(theBall.hitB1((block12.getX()+block12.getWidth()), block12.getY(), block12.getHeight())) {
                        theBall.reverseX();
                        paddle1.addPoints(15);
                        block12.move(lcd, -100);
                    }
                    if(theBall.hitB1((block13.getX()+block13.getWidth()), block13.getY(), block13.getHeight())) {
                        theBall.reverseX();
                        paddle1.addPoints(15);
                        block13.move(lcd, -100);
                    }
                    if(theBall.hitB1((block14.getX()+block14.getWidth()), block14.getY(), block14.getHeight())) {
                        theBall.reverseX();
                        paddle1.addPoints(15);
                        block14.move(lcd, -200);
                    }
                    if(theBall.hitB1((block15.getX()+block15.getWidth()), block15.getY(), block15.getHeight())) {
                        theBall.reverseX();
                        paddle1.addPoints(10);
                        block15.move(lcd, -100);
                    }
                    if(theBall.hitB1((block16.getX()+block16.getWidth()), block16.getY(), block16.getHeight())) {
                        theBall.reverseX();
                        paddle1.addPoints(10);
                        block16.move(lcd, -100);
                    }
                    if(theBall.hitB1((block17.getX()+block17.getWidth()), block17.getY(), block17.getHeight())) {
                        theBall.reverseX();
                        paddle1.addPoints(10);
                        block17.move(lcd, -100);
                    }
                    if(theBall.hitB1((block18.getX()+block18.getWidth()), block18.getY(), block18.getHeight())) {
                        theBall.reverseX();
                        paddle1.addPoints(10);
                        block18.move(lcd, -200);
                    }
                    if(theBall.hitB1((block19.getX()+block19.getWidth()), block19.getY(), block19.getHeight())) {
                        theBall.reverseX();
                        paddle1.addPoints(10);
                        block19.move(lcd, -200);
                    }
                    if(theBall.hitX()) { // If the ball hits one of the sides of the screen
                        if(theBall.getX()<7) { // If the ball hit paddle1's side
                            if(!paddle1.loseLife()) { // If paddle1 has no more lives
                                paddle1.setLives(3);
                                paddle1.setScore(0);
                                state = RESET1; // Reset the objects
                                break;
                            }
                            state = RESET2; // Reset the objects
                        }
                        theBall.reverseX();
                    }
                    if(theBall.hitY())
                        theBall.reverseY();
                    theBall.move(lcd);
                }
                if(paddle1.getScore()==310) {
                    state=WIN;
                }
                break;
        }
        drawScreen(paddle1, theBall, block1, block2, block3, block4, block5, block6, block7, block8, block9,
                   block11, block12, block13, block14, block15, block16, block17, block18, block19, false);
        drawScores(paddle1);
    }
}
