// host terminal LED dimmer control
#include "mbed.h"
Serial pc(USBTX, USBRX); // tx, rx
PwmOut PWM1(p21);
float brightness=0.0;
int main()
{
    PWM1.period(0.010); // set PWM period to 10 ms
    PWM1=0.8; // set duty cycle to 80%
    pc.printf("Control of LED dimmer by host terminal\n\r");
    pc.printf("Press 'u' = brighter, 'd' = dimmer\n\r");
    while(1) {
        char c = pc.getc();
        wait(0.001);
        if((c == 'u') && (brightness < 1.0)) {
            brightness += 0.1;
            PWM1= brightness;
        }
        if((c == 'd') && (brightness > 0.0)) {
            brightness -= 0.1;
            PWM1= brightness;
        }
        if(c=='x') {
            brightness = 0.5;
            PWM1= brightness;
        }
    
    pc.printf("%c %1.3f \n \r",c,brightness);
}
}
