#include "mbed.h"
#include "SerialHalfDuplex.h"

#define LINE_TIMER_LIMIT 0.01

DigitalIn digi_sen_r(p14);
AnalogIn ana_sen_r_outside(p17);
AnalogIn ana_sen_r_inside(p16);
AnalogIn ana_sen_l_inside(p15);
AnalogIn ana_sen_l_outside(p18);
DigitalIn digi_sen_l(p13);

Timer LineTimer;

Serial pc(USBTX, USBRX);

void CountLine(void);
void InitCountLine(void);

int line_count = 0, old_digi_sen_l = 0;

int main() {
    InitCountLine();
    while(1) {
        CountLine();
        pc.printf("line_count: %d\n", line_count);
    }
}

void InitCountLine(void)
{
    line_count = 0;
    old_digi_sen_l = digi_sen_l;    
}

void CountLine(void)
{
    if ((digi_sen_l == 1)&&(old_digi_sen_l == 0)) LineTimer.start();
        
        if ((digi_sen_l == 0)&&(old_digi_sen_l == 1)) {
                LineTimer.stop();
                if (LineTimer.read() > LINE_TIMER_LIMIT) line_count++;
                LineTimer.reset();
        }
        
        old_digi_sen_l = digi_sen_l;
}