#include "mbed.h"
#include "ComparatorIn.h"

#define MAX_SAMPLERATE 50000
#define Min_FREQ 20
#define MAX_FREQ 20000
#define MaxFrdmVAnalogRef 3.3
#define ThresholdOut 1000

Serial pc(USBTX,USBRX);

double AutoTrig, ValTrig, RiseOrFall, nWave;              //  1-0 for autotrig, value of trigger, on rise or fall of WaveFront
double AutoSr, ValSr;                    //  1-0 for autoSampleRate (max Value), value of SampleRate
double NumberSample, TranslationSample;  //  number of sample send to pc, first or last sample discard

double Threshold = 0;
double SampleRate = MAX_SAMPLERATE;
double MaxFrdmVAnalog;

int dimArr;
int stopArray = -1;
int startArray = -1;
int numbWave = 1;
double range;
double BottomLimit;
double TopLimit;
double adcRead;


AnalogIn DAC_In (PTB0);
ComparatorIn COMP_In(PTC8, PTE30); // in+ = PTC8, in- = 12-bit DAC


// Comparator callback functions
void cmp_rise_ISR(void){
    stopArray = stopArray + 1;
    startArray = 0;
    }

void cmp_fall_ISR(void){
    stopArray = stopArray + 1;
    startArray = 0;
    }

void Setting(double autoSr, double valSr, double autoTrig, double valTrig, double riseOrFall){
            if (autoSr == 1){           
            SampleRate = MAX_SAMPLERATE;           
            }
            
        else{            
            SampleRate = valSr;
            }        
        
        Threshold = (valTrig * MaxFrdmVAnalog) - BottomLimit;                   //Value Trigger desired / Max Input
                                                                                //all /MaxFrdmVAnalogRef
                                                                                //Threshold = (valTrig / MaxFrdmVAnalog) + BottomLimit; 
        
        if (autoTrig == 1){
            
            COMP_In.treshold(Threshold);                          //Set Threshold
            
            if (riseOrFall == 0){            
              COMP_In.rising(cmp_rise_ISR);                // Set pointer to rising interrupt functio
                }
            else {          
              COMP_In.falling(cmp_fall_ISR);               // Set pointer to falling interrupt function       
                }     
            }
        else{      
            COMP_In.treshold(ThresholdOut);    
            } 
    }

void printWave(int dimarr, int sampleRate, int numberSample, int translationSample){
    
    double dataLab[dimarr];
    for (int i = 0; i < dimarr; i++){ // fare if di variabile - su callback function
                
        adcRead = (DAC_In / MaxFrdmVAnalog) + BottomLimit; //all *MaxFrdmVAnalogRef?
        dataLab[i] = adcRead;
        
        double SR = sampleRate;
        wait(1 / SR);                    
        }
        
    int dimarray = dimarr - numberSample;
    int startarray = dimarray*translationSample/10;    
    
    for(int j = startarray; j< dimarr - dimarray; j++){                   
            printf("%f ", dataLab[j]);   
        }
    
    }


int main() {
    
    if (MAX_SAMPLERATE < 2*MAX_FREQ)
        {
            printf("Error SampleRate");
            }

    while(1) {
        // there are some parameters only for Labview
        pc.scanf("%f,%f,%f,%f,%f,%f,%f,%f,%f", &AutoTrig, &ValTrig, &nWave , &RiseOrFall, &AutoSr, &ValSr, &NumberSample, &TranslationSample, &TopLimit, &BottomLimit);
        double DimensionArray = (SampleRate / Min_FREQ) * 2;        //at least 2 waveform of the minimum Frequ   
        dimArr = int (DimensionArray);
        //numbWave = int (nWave);

        range = TopLimit - BottomLimit;
        MaxFrdmVAnalog = MaxFrdmVAnalogRef / range;
        
        Setting(AutoSr, ValSr, AutoTrig, ValTrig, RiseOrFall); //testing - setting every some sec(contator intern)
        if (AutoTrig == 1){
            if (startArray == 0 && stopArray == 0){
                printWave(dimArr, SampleRate, NumberSample, TranslationSample);
                startArray = -1;
                stopArray = -1;
                }    
            }
        else{
            printWave(dimArr, SampleRate, NumberSample, TranslationSample);
            }
        }
    }

