#include "Gears.h"
#include "mbed.h"
#include "PinDetect.h"
#include "Comms.h"

//Detect and process presses of the Gear buttons

//Initialise members and set up button handlers
Gears::Gears(PinName up, PinName neutral, PinName down, unsigned char* _currentGear, Comms* _remote)
{
    currentGear = _currentGear;
    remote = _remote;

    btnUp = new PinDetect(up, PullUp);
    btnNeutral = new PinDetect(neutral, PullUp);
    btnDown = new PinDetect(down, PullUp);

    //Set buttons as pull down to assert
    btnUp->setAssertValue(0);
    btnDown->setAssertValue(0);
    btnNeutral->setAssertValue(0);
    
    //Attach handlers
    btnUp->attach_asserted(this, &Gears::up);
    btnDown->attach_asserted(this, &Gears::down);
    btnNeutral->attach_asserted(this, &Gears::neutral);
    
    //Start checking buttons
    btnUp->setSampleFrequency();
    btnDown->setSampleFrequency();
    btnNeutral->setSampleFrequency();
}

void Gears::up()
{
    //Send change up command
    remote->send(2);
    
    //Update state
    if(*currentGear < 6)
        (*currentGear)++;
}

void Gears::neutral()
{
    //Sent neutral command
    remote->send(0);
    
    //Update state
    *currentGear = 0;
}

void Gears::down()
{
    //Send change down command
    remote->send(1);
    
    //Update state
    if(*currentGear > 0)
    {
        (*currentGear)--;
    }
}