#include "mbed.h"
#include "rtos.h"
#include "Servo.h"

Serial pc(USBTX, USBRX);

DigitalOut trig(D3);
DigitalIn echo(D2);
Servo myservo(D4);

Thread hilo_tarea1;
Thread hilo_tarea2;
Timer senal;
float distancia;
float angle;
void tarea1(void);
void tarea2(void);

int main()
{

    hilo_tarea1.start(tarea1);
    hilo_tarea2.start(tarea2);
    hilo_tarea1.set_priority(osPriorityNormal);
    while (true) {

    }
}

void tarea1(void)
{
    while(true) {
        senal.reset();
        trig = 0;
        wait_us(2);
        trig = 1;
        wait_us(10);
        trig = 0;
        while(echo==0);
        senal.start();
        while(echo==1);
        senal.stop();
        distancia = (senal.read_us())/58;
        pc.printf("%.f;%.f\n\r",angle,distancia);
        ThisThread::sleep_for(50);
    }
}

void tarea2(void)
{
    float range = 0.0009;
    bool direction = true;
    float position = 0.0;
    myservo.calibrate(range, 45.0);
    while(true) {
        if(direction) {
            for (int i=-90; i< 90; i++) {
                angle= i+90;
                myservo.position(i);
                wait_ms(17);
            }
            direction=false;
        } else {
            for (int i=90; i> -90; i--) {
                angle = i+90;
                myservo.position(i);
                wait_ms(17);
            }
            direction=true;

        }
    }
}