#include "mbed.h"
#include "MMA8451Q.h"
Serial pc (USBTX,USBRX);
#define MMA8451_I2C_ADDRESS (0x1d<<1)


int main(void)
{
    pc.baud(115200);
    MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);

    pc.printf("MMA8451 ID: %d\n\r", acc.getWhoAmI());

    while (true) {
        float x, y, z;
        x = abs(acc.getAccX());
        y = abs(acc.getAccY());
        z = abs(acc.getAccZ());
        wait(0.1f);
        pc.printf("X: %1.2f, Y: %1.2f, Z: %1.2f\n\r", x, y, z);
        wait(1);
    }
}
