/*
 * - Proyecto:      Apagado Temporizado MEGAPACA
 * - Lenguaje:      ANSI C/C++ (mbed)
 * - Tarjeta:       NUCLEO F303K8
 * - Referencias:
 * - Fecha:         2017/Septiembre
 * - Autor(es):     Felícito Manzano /
                    Mario Vargas
 * - Compañia:      V.S.R. de Centroamérica
 * - País:          SV / CR
 */

#include "constantes.hpp"
#include "BufferedSerial.h"

int incrementar_trama(int *tramas)
{
    /*
    Esta función recibe un entero que es el contador de tramas
    realiza el incremento en uno y verifica si el valor es mayor
    o igual que 65535 que es equivalente a 0xFFFF. Si se cumple
    la condución se regresa el valor a 1.
    Esta función siempre retorna 0.
    */
    int actual = *tramas;
    int limite = 65535;
    actual++;

    if (actual > limite) {
        *tramas = 1;
    } else {
        *tramas = actual;
    }
    return(0);
}

int iniciando(BufferedSerial *puerto_cp)
{
    /*
    Esta función recibe los puertos Seriales del GV300 y de la PC
    conectada por USB para notificar que se ha reiniciado la interfaz.
    Siempre retorna 0
    */
    puerto_cp -> printf("%s\r\n", RESET_TXT);
    wait_ms(T_TX);
    return(0);
}

bool leer_uart(BufferedSerial *puerto, char buffer[128])
{
    /* Esta función se encarga de leer el puerto serial y
    almacenar la respuesta en un buffer de datos de entrada.
    Si se lee información, la función devuelve 1, sino 0. */

    bool    x = false;
    int     w = 0;
    

    if (puerto -> readable()) {
        x = true;
        while (puerto -> readable()) {
            char incoming_char = puerto -> getc();
            buffer[w] = incoming_char;
            w++;
        }
        buffer[w] = '\0';
    }
    return(x);
}

int procesar_trama(char buffer[128])
{
    /* Esta función se encarga de verificar que se ha recibido una trama desde Skytrack
    o si el comando de apagado se ejecutó apropiadamente. */
    
    int x = 0;

    if (strstr(buffer, ABORT_TXT) != NULL) {
        x = 1; // Se recibió trama con "ABORTAR"
    }

    if (strstr(buffer, GTOUT_TXT) != NULL) {
        x = 2; // Se recibió trama con "ACK:GTOUT"
    }
    
    if (strstr(buffer, GV300_OK) != NULL) {
        x = 3; // El GV300 se la pasa mandando OK
    }
    
    return(x);
}