/*
 * - Proyecto:      Apagado Temporizado MEGAPACA
 * - Lenguaje:      ANSI C/C++ (mbed)
 * - Tarjeta:       NUCLEO F303K8
 * - Referencias:
 * - Fecha:         2017/Septiembre
 * - Autor(es):     Felícito Manzano /
                    Mario Vargas
 * - Compañia:      V.S.R. de Centroamérica
 * - País:          SV / CR
 */

#include "mbed.h"
#include "BufferedSerial.h"
#include "constantes.hpp"
#include "funciones_basicas.h"
#include "PinDetect.h"

/*  CONFIGURACIÓN DE HARDWARE
************************************** */
BufferedSerial  gv300(USBTX, USBRX);
PinDetect       input(PA_10); //PC_13
DigitalOut      myled(LED1); 

// DECLARACIÓN DE VARIABLES
//**************************************
float           tiempo_actual           = 0.0;      // Para almacenar el valor del temporizador
int             contador_tramas         = 2;        // Para contar las tramas enviadas a SKT300
int             factor                  = 1;        // Para multiplicar
int             i                       = 0;        // Uso genérico
int             contador_pulsos         = 0;
bool            apagar                  = false;
char            skytrack_frame[128];                // Salida de datos para SKT300
char            buffered_frame[128];                      // Salida temporal de datos


// DECLARACIÓN DE TEMPORIZADORES
//**************************************
Timer           funcionando;        // Temporizador para generar el motivo por tiempo de lectura de la tarjeta NUCLEO
Timer           apagando_cp;        // Temporizador para consultar el estatus de la puerta.

// Funciones de Interrupción
void flanco_negativo_SKT300N() {
    contador_pulsos++;
}

int main() {
    // CONFIGURAR INTERFACES
    //***********************************
    gv300.baud(115200);
    input.mode(PullUp);
    input.attach_asserted(&flanco_negativo_SKT300N);
    input.setSampleFrequency(50000);
    wait(0.4);
    iniciando(&gv300);
    
    // Inicio de temporizadores y RTC
    funcionando.start();
        
    while(1) {
        
        // Validar puslsos.
        if (contador_pulsos >= 1) {
            myled = 1;
            wait(7.0);
            if (contador_pulsos == PULSOS_APAGAR) {
                apagar = true;
            } else {
                apagar = false;
            }
            contador_pulsos = 0;
            myled = 0;
        }
        
        
        // CONSULTAR SI SE HA PRESIONADO EL BOTÓN 
        if ((apagar) && (apagando_cp.read() < 0.5)) {
            //pcusb.printf("\r\nBoton de panico presionado.\r\n");
            //pcusb.printf("Apagando en T-15\r\n");
            apagar = false;
            apagando_cp.start();
            sprintf(skytrack_frame,"%s%s%s%s%04X%s", 
                    CABECERA_TX, CODIGO_INT, INIT_SHUTDOWN, 
                    FIN_CABECERA_TX, contador_tramas, ULTIMO_CARACTER);
            gv300.printf("%s\r\n", skytrack_frame);
            memset(skytrack_frame, '\0', sizeof(skytrack_frame));               // Vaciar el buffer de Skytrack Frame
            incrementar_trama(&contador_tramas);
        }

        // VALIDAR SI SE DEBE ABORTAR
        // Leer puerto Serial
        if (leer_uart(&gv300, buffered_frame)) {
            //pcusb.printf("Trama recibida...\r\n");
            i = procesar_trama(buffered_frame);
            if(i == 1) { // 1 = ABORTAR
                apagar = 0;
                factor = 1;
                apagando_cp.stop();
                apagando_cp.reset();
                sprintf(skytrack_frame,"%s%s%s%s%04X%s", 
                    CABECERA_TX, CODIGO_INT, CANC_SHUTDOWN, 
                    FIN_CABECERA_TX, contador_tramas, ULTIMO_CARACTER);
                gv300.printf("%s\r\n", skytrack_frame);
                //pcusb.printf("Apagado por panico ABORTADO.\r\n");
            } else if (i == 3){
                // Nada por hacer por el OK
            } else {
                // pcusb.printf("Trama DESCONOCIDA.\r\n");
            }
        }

        // CONSULTAR SI SE DEBE APAGAR
        tiempo_actual = apagando_cp.read();                              // Leer el temporizador de Heartbeat
        if (tiempo_actual >= (MINUTO * factor)) {
            //pcusb.printf("Apagando en T-%d\r\n", (T_15 - factor));
            factor++;
        }

        if (tiempo_actual >= TIME_SHUTDOWN) {
            //pcusb.printf("Apangado en progreso...\r\n");
            apagando_cp.stop();
            apagando_cp.reset();
            apagar = 0;
            factor = 1;
            gv300.printf("%s\r\n", SHUTDOWN_TXT);
            wait_ms(T_TX);
            // Leer puerto Serial
            i = leer_uart(&gv300, buffered_frame);
            if (i) {
                // Confirmar resultado de Apagado
                i = procesar_trama(buffered_frame);
                if (i == 2) { // +ACK
                    sprintf(skytrack_frame,"%s%s%s%s%04X%s", 
                        CABECERA_TX, CODIGO_INT, SHUTDOWN_DONE, 
                        FIN_CABECERA_TX, contador_tramas, ULTIMO_CARACTER);
                    gv300.printf("%s\r\n", skytrack_frame);
                    //pcusb.printf("Apagado remoto +EXITOSO!\r\n");
                } else {
                    sprintf(skytrack_frame,"%s%s%s%s%04X%s", 
                        CABECERA_TX, CODIGO_INT, SHUTDOWN_ERRO, 
                        FIN_CABECERA_TX, contador_tramas, ULTIMO_CARACTER);
                    gv300.printf("%s\r\n", skytrack_frame);
                    //pcusb.printf("Apagado remoto -FALLIDO!\r\n");    
                }
            }  else { 
                sprintf(skytrack_frame,"%s%s%s%s%04X%s", 
                        CABECERA_TX, CODIGO_INT, SHUTDOWN_ERRO, 
                        FIN_CABECERA_TX, contador_tramas, ULTIMO_CARACTER);
                gv300.printf("%s\r\n", skytrack_frame);
                //pcusb.printf("Apagado remoto -FALLIDO!\r\n");
            }
        }

        // ENVIAR HEARTBEAT A SKYTRACK
        tiempo_actual = funcionando.read();                              // Leer el temporizador de Heartbeat
        if (tiempo_actual >= TIME_HEARTBEAT) {
            //pcusb.printf("\r\nMultipuertos estable.\r\n");
            funcionando.reset();
            sprintf(skytrack_frame, "%s%s%04X%s\r\n",
                    ALIVE, FIN_CABECERA_TX, contador_tramas, ULTIMO_CARACTER);
            gv300.printf("%s\r\n", skytrack_frame);
            memset(skytrack_frame, '\0', sizeof(skytrack_frame));               // Vaciar el buffer de Skytrack Frame
            incrementar_trama(&contador_tramas);
        }
    }
} 