/*
 * - Proyecto:      Apagado Temporizado MEGAPACA
 * - Lenguaje:      ANSI C/C++ (mbed)
 * - Tarjeta:       NUCLEO F303K8
 * - Referencias:
 * - Fecha:         2017/Septiembre
 * - Autor(es):     Felícito Manzano /
                    Mario Vargas
 * - Compañia:      V.S.R. de Centroamérica
 * - País:          SV / CR
 */

 #include "constantes.hpp"

/* DEFINICIÓN DE CONSTANTES PARA GV300 */
const char CABECERA_TX[]        = "AT+GTDAT=gv300,2,,TCA|";
const char CODIGO_INT[]         = "021|";
const char FIN_CABECERA_TX[]    = ",0,,,,";
const char ULTIMO_CARACTER[]    = "$";
const char SEPARADOR[]          = ";";
const char RESET_TXT[]          = "AT+GTDAT=gv300,2,,***BOOTING***,1,,,,0001$";
const char ALIVE[]              = "AT+GTDAT=gv300,2,,**NUCLEO-OK**,1,,,,";
const char SHUTDOWN_TXT[]       = "AT+GTOUT=gv300,1,,,0,0,0,0,0,0,0,,0,0,,,,C0C0$";
const char INIT_SHUTDOWN[]      = "Iniciando apagado por Evento de Panico T-05";
const char CANC_SHUTDOWN[]      = "Apagado por Evento de Panico - CANCELADO";
const char SHUTDOWN_DONE[]      = "Apagado por Evento de Panico - REALIZADO";
const char SHUTDOWN_ERRO[]      = "Apagado por Evento de Panico - ERROR";
const char GTOUT_TXT[]          = "ACK:GTOUT";
const char ABORT_TXT[]          = "ABORTAR";
const char GV300_OK[]           = "OK";
const int PULSOS_APAGAR         = 2;

// CONSTANTES DE PUERTO SERIAL
const int BUFF_SIZE   = 498;
const int TX_MULTIP   = 1;


// OTRAS CONSTANTES
const int T_ESPERA_CP       = 300;       // mili segundos
const int T_TX              = 100;       // mili segundos
const int T_15              = 5;        // minutos
const float MINUTO          = 60.0;      // segundos
const float TIME_HEARTBEAT  = 600.0;     // segundos
const float TIME_SHUTDOWN   = 300.0;     // segundos