#ifndef INCUDED_SERIAL_CONNECTED_MCU_HPP
#define INCUDED_SERIAL_CONNECTED_MCU_HPP

#include "rotary_encoder_ab_phase.hpp"
#include "servo.hpp"
#include "serial_connected_mcu_slave.hpp"
#include "mbed.h"

namespace serial_connected_mcu {

class serial_connected_mcu {
public:
    static serial_connected_mcu* instance();
    void update();

private:
    serial_connected_mcu();
    ~serial_connected_mcu();
    
    // 実体を記述しない
    void operator=(const serial_connected_mcu&);
    serial_connected_mcu(const serial_connected_mcu&);
    
    static serial_connected_mcu* _instance;
    
    static const float _sampling_delta_time_usec;
    
    static const PinName _servo_pins[];
    static TIM_TypeDef* _encoder_timers[];
    static const size_t _encoder_pulse_per_revol;
    static const PinName _analog_input_pins[];
    
    static const size_t _servo_num;
    static const size_t _analog_input_num;
    enum {
        ENCODER_NUM = 3
    };
    
    servo** _servos;
    rotary_encoder_ab_phase** _encoders;
    AnalogIn** _analog_inputs;
    
    float* _prev_encoders_values;
    Timer _timer;
    float _encoders_speed[ENCODER_NUM];
    
    serial_connected_mcu_slave _slave;
};

} /* namespace serial_connected_mcu */

#endif
