#include "serial_communication.hpp"
#include "mbed.h"
#include "SimpleMapDeSerializer.hpp"
#include "communication.hpp"
#include <map>

serial_communication* serial_communication::instance_ = NULL;

serial_communication::serial_communication() : serial_(USBTX, USBRX),
                                               semaphore_(true),
                                               is_new_data_existing_(false) {
    // 基準値で初期化
    map_["stkLX"] = communication::velocity_offset_;
    map_["stkLY"] = communication::velocity_offset_;
    /*
    serial_.baud(115200);
    serial_.format(7, RawSerial::None, 1);
    serial_.attach(this, &serial_communication::receive);
    */
}

serial_communication::~serial_communication() {
    delete instance_;
}

int serial_communication::get(string key) {
    return map_[key];
}

bool serial_communication::update() {
    if (is_new_data_existing_) {
        is_new_data_existing_ = false;
        SimpleMapSerialization::simpleMapDeSerializer(data_, ',', map_);
        return true;
    }
    
    return false;
}

void serial_communication::receive() {
    char c = serial_.getc();
    
    switch (c) {
        case '\n':
            data_ = buffer_;
            buffer_.erase();
            buffer_ += "a,0,";
            is_new_data_existing_ = true;
            
            break;
            
        case '\r':
            break;
            
        default:
            buffer_ += c;
            break;
    }
}
