#ifndef INCLUDED_SERIAL_COMMUNICATION_H
#define INCLUDED_SERIAL_COMMUNICATION_H

#include <string>
#include <map>
#include "mbed.h"

class serial_communication {
public:
    typedef std::string string;
    typedef std::map<string, int> map;
    
    static serial_communication* instance() {
        if (instance_ == NULL) {
            instance_ = new serial_communication;
        }
        return instance_;
    }
    
    int get(string key);
    bool update();

    void receive();
private:
    serial_communication();
    ~serial_communication();
    
    // 実装しない
    serial_communication& operator=(const serial_communication&);
    serial_communication(const serial_communication&);
    
    RawSerial serial_;
    string buffer_;
    map map_;
    bool semaphore_;
    bool is_new_data_existing_;
    string data_;
    
    static serial_communication* instance_;
};

#endif
