#include "mbed.h"
#include "rotary_encoder_a_phase.hpp"
#include "rotary_encoder_ab_phase.hpp"

int main() {
    const size_t encoder_num = 3;
    rotary_encoder* e[] = {
        new rotary_encoder_a_phase( /* timer_type = */TIM1, /* pulse_per_revol = */100),
        new rotary_encoder_ab_phase(/* timer_type = */TIM2, /* pulse_per_revol = */100),
        new rotary_encoder_ab_phase(/* timer_type = */TIM3, /* pulse_per_revol = */100)
    };
    
    for (size_t i = 0; i < encoder_num; ++i) {
        e[i]->start();
    }
    
    const float t = 2.0f;
    
    while (true) {
        wait(t);
        for (size_t i = 0; i < encoder_num; ++i) {
            // 回転数/秒 に60を掛けて 回転数/分 にする
            printf("%f, ", (e[i]->get_revol_num() / t) * 60.0f);
            e[i]->stop();
        }
        printf("\n");
        wait(t);
        
        for (size_t i = 0; i < encoder_num; ++i) {
            e[i]->start();
        }
        wait(t);
        
        for (size_t i = 0; i < encoder_num; ++i) {
            // 回転数/秒 に60を掛けて 回転数/分 にする
            printf("%f, ", (e[i]->get_revol_num() / t) * 60.0f);
            e[i]->stop();
        }
        printf("\n");
    }
    
    return 0;
}
