#ifndef INCLUDED_MBED_STL_ROTARY_ENCODER_A_PHASE_H
#define INCLUDED_MBED_STL_ROTARY_ENCODER_A_PHASE_H

#include "rotary_encoder_base.hpp"
#include "mbed.h"

/*
 * TIM1_CH1: AF1 @ PA_8
 * TIM1_CH2: AF1 @ PA_9
 *
 * TIM2_CH1: AF1 @ PA_0
 * TIM2_CH2: AF1 @ PA_1
 *
 * TIM3_CH1: AF2 @ PB_4
 * TIM3_CH2: AF2 @ PB_5
 *
 * TIM4_CH1: AF2 @ PB_6, PD_12
 * TIM4_CH2: AF2 @ PB_7, PD_13
 *
 * TIM5_CH1: AF2 @ PA_0*    *TIM5 used by mbed system ticker so unavailable
 * TIM5_CH2: AF2 @ PA_1*
 *
 */
 
namespace mbed_stl {

class rotary_encoder_a_phase : public rotary_encoder_base {
public:
    rotary_encoder_a_phase(TIM_TypeDef* timer_type, size_t resolution) :
        rotary_encoder_base(timer_type, TIM_ENCODERMODE_TI1, resolution) {}
    virtual ~rotary_encoder_a_phase() {}
};

} /* namespace mbed_stl */

#endif
