#include "communication.hpp"
#include "moving_object.hpp"
#include "serial_communication.hpp"

#include "mbed_stl.hpp"
#include "mbed.h"

communication* communication::instance_ = NULL;
const int communication::velocity_offset_ = 32767;
//const float communication::analog_stick_lower_limit_ = 0.2f;
//const size_t communication::velocity_div_num_ = 8;

communication::communication() {}

node_system::moving_object::CONTROL_MODE communication::get_mode() const {
    return node_system::moving_object::MANUAL_MODE;
}

communication::vector2f communication::get_velocity() const {
    uint32_t iv[] = {
        serial_communication::instance()->get("stkLX"),
        serial_communication::instance()->get("stkLY")
    };
    
    if ((iv[0] == velocity_offset_) && (iv[1] == velocity_offset_)) {
        return vector2f();
    }
    
    vector2f v;
    
    // 受信データは [0, 65535] の範囲であるので [-1, 1] に変換する
    for (uint32_t i = 0; i < 2; ++i) {
        v[i] = iv[i];
        v[i] -= velocity_offset_;
        v[i] /= velocity_offset_;
    }
    if (v.length() > 1.0f) {
        //v = v.unit();
        return v.unit();
    }
    return v;
    /*
    float p = 2.0f * PI;// / 8.0f;// / velocity_div_num_;
    float rad = atan2(v.y(), v.x());
    rad += p * 0.5f;
    rad /= p;
    rad *= p;
    */
    //float l = sqrt(v.x() * v.x() + v.y() * v.y());
    
    //float l = v.length();
    
    //return vector2f(cos(rad), sin(rad));
    //return vector2f(0.3f * cos(rad), 0.3f * sin(rad));
    //return vector2f(l * cos(rad), l * sin(rad));
    
    /*
    if (v.length() < analog_stick_lower_limit_) {
        return vector2f();  // しきい値以下なら移動操作無しとみなす
    }
    */
    //return v;
    
    /*
    vector2f velocity = v.unit();
    return velocity;
    */
}
float communication::get_angular_velocity_rad_per_sec() const {
    return 0.0f;
}
communication::vector2f communication::get_target_position_mm() const {
    return vector2f();
}
float communication::get_target_heading_rad() const {
    return 0.0f;
}
