#ifndef INCLUDED_NODE_SYSTEM_COMMUNICATION_H
#define INCLUDED_NODE_SYSTEM_COMMUNICATION_H

#include "moving_object.hpp"
#include "mbed_stl.hpp"

class communication {
public:
    typedef mbed_stl::linear_algebra::vector2f vector2f;
    
    static const int velocity_offset_;

    static communication* instance() {
        if (instance_ == NULL) {
            instance_ = new communication;
        }
        return  instance_;
    }
    static void destory() {
        delete instance_;
    }
    node_system::moving_object::CONTROL_MODE get_mode() const;
    vector2f get_velocity() const;
    float    get_angular_velocity_rad_per_sec() const;
    vector2f get_target_position_mm() const;
    float    get_target_heading_rad() const;
    
private:
    communication();
    ~communication() {}
    // singletonにつき禁止のため以下の二つの実装は無し
    void operator=(const communication& s);
    communication(const communication& s);
    
    static communication* instance_;
    //static const float analog_stick_lower_limit_;
    //static const size_t velocity_div_num_;
};

#endif
