#include "YMotorDriverBase.h"
#include "YMotorDriverSupplier.h"
#include "mbed.h"

const float YMotorDriverSupplier::mDuty = 0.20f;
const PinName YMotorDriverSupplier::mLazerPinName = dp2;
//const uint32_t YMotorDriverSupplier::mValidSignalWidth_us = 40 * 1000;
//const uint32_t YMotorDriverSupplier::mValidSignalWidth_us = 17 * 1000;
const uint32_t YMotorDriverSupplier::mValidSignalWidth_us = 10;

YMotorDriverSupplier::YMotorDriverSupplier( char address ) : YMotorDriverBase( address, /* id = */ 5 ){
    mLazer = new InterruptIn( mLazerPinName );
    mLazer->rise( this, &YMotorDriverSupplier::itr );
    mTimer      = new Timer;
    mIsWorking  = false;
}

void YMotorDriverSupplier::itr(){
    if ( ( mTimer->read_us() > mValidSignalWidth_us ) && mLazer->read() ){
        mIsWorking = false;
        mTimer->reset();
        mTimer->stop();
    }
}

void YMotorDriverSupplier::updateI2CSlave(){
    switch ( mI2C->receive() ){
        case I2CSlave::ReadAddressed:{
            char buf = mIsWorking;
            mI2C->write( &buf, 1 );
            break;
        }
        case I2CSlave::WriteGeneral:
            break;
        
        case I2CSlave::WriteAddressed:{
            char buf;
            mI2C->read( &buf, 1 );
            
            if ( buf && !mIsWorking ){
                mTimer->reset();
                mTimer->start();
            }
            
            mIsWorking = buf;
            break;
        }
        
        case I2CSlave::NoData:
            break;
    }
}

void YMotorDriverSupplier::updateSpecial(){
    MotorAction action = BRAKE;
    
    if ( mIsWorking ){
        action = FORWARD;
        setDuty( mDuty );
    }
    
    setMotorAction( action );
}
