#ifndef INCLUDED_YMOTOR_DRIVER_SUPPLIER_H
#define INCLUDED_YMOTOR_DRIVER_SUPPLIER_H

#include "mbed.h"
#include "YMotorDriverBase.h"

class YMotorDriverSupplier : public YMotorDriverBase{
public:
    YMotorDriverSupplier( char address );
    
private:
    virtual void updateI2CSlave();
    virtual void updateSpecial();
    void itr();

    static const float mDuty;
    static const PinName mLazerPinName;
    static const uint32_t mValidSignalWidth_us;
    
    InterruptIn* mLazer;
    Timer* mTimer;
    bool mIsWorking;
};

#endif
