#ifndef INCLUDED_YMOTOR_DRIVER_SHOOTER_H
#define INCLUDED_YMOTOR_DRIVER_SHOOTER_H

#include "YMotorDriverBase.h"

class YMotorDriverShooter : public YMotorDriverBase{
public:
    enum ShooterActionType{
        STOP        = 0x00, // 0000(2)
        WORKING_8V  = 0x01, // 0001(2)
        WORKING_12V = 0x03, // 0011(2)
        WORKING_16V = 0x07, // 0111(2)
        WORKING_20V = 0x0F  // 1111(2)
    };

    YMotorDriverShooter( char address );
    
private:
    virtual void write();
    virtual void updateI2CSlave();

    static const PinName mRelayDriveDoutPinName[];
    
    DigitalOut** mRelayDriveDout;
    ShooterActionType mActionType;
};

#endif
