#include "YMotorDriverShooter.h"
#include "YMotorDriverBase.h"
#include "YMotorDriver.h"
#include "mbed.h"

const PinName YMotorDriverShooter::mRelayDriveDoutPinName[] = {
    dp14,
    dp11,
    dp4,
    dp2
};

YMotorDriverShooter::YMotorDriverShooter( char address ) : YMotorDriverBase( address, YMotorDriver::SHOOTER_ID ){
    mRelayDriveDout = new DigitalOut*[ 4 ];
    for ( int i = 0; i < 4; ++i ){
        mRelayDriveDout[ i ] = new DigitalOut( mRelayDriveDoutPinName[ i ] );
    }
    
    mActionType = STOP;
}

void YMotorDriverShooter::updateI2CSlave(){
    switch ( mI2C->receive() ){
        case I2CSlave::ReadAddressed:{
            char buf = mActionType;
            mI2C->write( &buf, 1 );
            break;
        }
        case I2CSlave::WriteGeneral:
            break;
        
        case I2CSlave::WriteAddressed:{
            char buf;
            mI2C->read( &buf, 1 );
            mActionType = static_cast< ShooterActionType >( buf );
            break;
        }
        
        case I2CSlave::NoData:
            break;
    }
}

void YMotorDriverShooter::write(){
    for ( int i = 0; i < 4; ++i ){
        mRelayDriveDout[ i ]->write( ( mActionType >> i ) & 0x01 );
    }
}
