#ifndef INCLUDED_YMOTOR_DRIVER_SERVO_H
#define INCLUDED_YMOTOR_DRIVER_SERVO_H

#include "mbed.h"
#include "YMotorDriverBase.h"
#include "PID.h"

class YMotorDriverServo : public YMotorDriverBase, public PID{
public:
    YMotorDriverServo( char address, int id );
    ~YMotorDriverServo();
    
protected:
    void stop(){
        mTargetPosition = mPosition;
    }
    void setTargetPosition( float p ){
        if ( p < 0.0f ){
            p = 0.0f;
        } else if ( p > 1.0f ){
            p = 1.0f;
        }
        mTargetPosition = ( mServoRangeMax[ mID ] - mServoRangeMin[ mID ] ) * p + mServoRangeMin[ mID ];
    }
    float getPosition(){
        return mPosition;
    }
    float getTargetPosition(){
        return mTargetPosition;
    }
    
private:
    virtual void updateSpecial();
    virtual void updateI2CSlave();
    virtual void control( float c );
    virtual void updateServoSpecial(){}

    static const float mAllowableError[];
    static const PinName mAnalogInPinName;
    static const float mLowPassFilterCoeff[];
    static const float mPCoeff[];
    static const float mICoeff[];
    static const float mDCoeff[];
    static const float mServoMaxDuty[];
    static const float mServoMinDuty[];
    static const float mServoRangeMin[];
    static const float mServoRangeMax[];
    
    AnalogIn* mAnalogIn;
    float mPosition;
    float mTargetPosition;
    bool mHasWorked;
    int mID;
};

#endif