#include "YMotorDriverBase.h"
#include "YMotorDriverPusher.h"
#include "mbed.h"

//const float YMotorDriverPusher::mDuty = 0.75f;
const float YMotorDriverPusher::mDuty = 1.0f;
const PinName YMotorDriverPusher::mDinPinName[] = {
    dp2,
    dp4
};

YMotorDriverPusher::YMotorDriverPusher( char address ) : YMotorDriverBase( address ){
    mSwitchDin = new DigitalIn*[ 2 ];
    for ( int i = 0; i < 2; ++i ){
        mSwitchDin[ i ] = new DigitalIn( mDinPinName[ i ] );
    }
    mActionType = NO_OPERATION;
    mState = BETWEEN;
}

void YMotorDriverPusher::updateI2CSlave(){
    switch ( mI2C->receive() ){
        case I2CSlave::ReadAddressed:{
            char buf = mState;
            mI2C->write( &buf, 1 );
            break;
        }
        case I2CSlave::WriteGeneral:
            break;
        
        case I2CSlave::WriteAddressed:{
            char buf;
            mI2C->read( &buf, 1 );
            mActionType = static_cast< ActionType >( buf );
            break;
        }
        
        case I2CSlave::NoData:
            break;
    }
}

void YMotorDriverPusher::updateSpecial(){
    if ( mSwitchDin[ DRAW_LIMIT_SWITCH ]->read() ){
        if ( mActionType == DRAWING ){
            // スイッチが押されているのにその方向に動こうとしていたら止める
            mActionType = NO_OPERATION;
        }
        mState = HAS_FINISHED_DRAWING;
    } else if ( mSwitchDin[ PUSH_LIMIT_SWITCH ]->read() ){
        if ( mActionType == PUSHING ){
            // スイッチが押されているのにその方向に動こうとしていたら止める
            mActionType = NO_OPERATION;
        }
        mState = HAS_FINISHED_PUSHING;
    } else {
        mState = BETWEEN;
    }
    
    MotorAction action = BRAKE;
    if ( mActionType == DRAWING ){
        action = REVERSE;
    } else if ( mActionType == PUSHING ){
        action = FORWARD;
    }
    
    setMotorAction( action );
    setDuty( mDuty );
}
