#ifndef INCLUDED_YMOTOR_DRIVER_PUSHER_H
#define INCLUDED_YMOTOR_DRIVER_PUSHER_H

#include "mbed.h"
#include "YMotorDriverBase.h"

class YMotorDriverPusher : public YMotorDriverBase{
public:
    enum DinID{
        DRAW_LIMIT_SWITCH,
        PUSH_LIMIT_SWITCH
    };  
    enum ActionType{
        NO_OPERATION,
        DRAWING,
        PUSHING
    };
    enum State{
        BETWEEN,
        HAS_FINISHED_DRAWING,
        HAS_FINISHED_PUSHING
    };

    YMotorDriverPusher( char address );
    
private:
    virtual void updateI2CSlave();
    virtual void updateSpecial();
    
    static const float mDuty;
    static const PinName mDinPinName[];
    
    DigitalIn** mSwitchDin;
    ActionType mActionType;
    State mState;
};

#endif
