#ifndef INCLUDED_YMOTOR_DRIVER_BASE_H
#define INCLUDED_YMOTOR_DRIVER_BASE_H

#include "mbed.h"
#include "PWMOut.h"

class YMotorDriverBase{
public:
    enum MotorAction{
        FORWARD,
        REVERSE,
        BRAKE,
        RELEASE
    };

    YMotorDriverBase( char address );
    YMotorDriverBase( char address, int id );
    YMotorDriverBase( char address, float maxDuty, float minDuty );
    ~YMotorDriverBase();
    
    virtual void update();
    
    void setMotorAction( MotorAction action ){
        mAction = action;
    }
    void setDuty( float d ){
        mDuty = middle( mMinDuty, d, mMaxDuty );
    }
    void setPercent( float p );
    
    float getMinDuty(){
        return mMinDuty;
    }
    float getMaxDuty(){
        return mMaxDuty;
    }
    
protected:
    virtual void write();
    
    I2CSlave* mI2C;
    DigitalOut* mLED;

private:
    virtual void updateI2CSlave();
    virtual void updateSpecial(){}
    
    static float middle( float min, float d, float max ){
        if ( min > max ){
            float tmp = min;
            min = max;
            max = tmp;
        }
        
        if ( d < min ){
            return min;
        } else if ( d > max ){
            return max;
        }
        
        return d;
    }
    
    void init();

    PWMOut* mMotorDrivePwm;
    DigitalOut* mMotorDriveDout[ 4 ];
    
    MotorAction mAction;
    float mDuty;
    
    const char mAddress;
    int mID;
    
    static const PinName mMotorDriveDoutPinName[ 4 ];
    static const PinName mMotorDrivePwmPinName;
    static const PinName mLEDPinName;
    static const PinName mSerialPinName[ 2 ];
    static const PinName mI2CPinName[ 2 ];
    static const int mPwmCycle_us;
    static const float mMaxDutyList[];
    static const float mMinDutyList[];
    float mMaxDuty;
    float mMinDuty;
};

#endif