#ifndef INCLUDED_YMOTOR_DRIVER_H
#define INCLUDED_YMOTOR_DRIVER_H

#include "mbed.h"

class YMotorDriverBase;

class YMotorDriver{
public:
    enum MotorTypeID{
        STEERING_0_ID,
        STEERING_1_ID,
        STEERING_2_ID,
        SHOOTER_ID,
        GENERAL_ID
    };
    
    static YMotorDriver* getInstance(){
        if ( mInstance == NULL ){
            mInstance = new YMotorDriver();
        }
        return mInstance;
    }
    void update();
    
private:
    YMotorDriver();
    ~YMotorDriver();
    
    static YMotorDriver* mInstance;

    static const PinName mAddressDeciderPinName[];
    static const char mYMotorDriverBaseAddress[];
    static const char mYMotorDriverServoAddress[];
    static const char mYMotorDriverSupplierAddress[];
    static const char mYMotorDriverPusherAddress[];
    static const char mYMotorDriverShooterAddress[];
    static const char mYMotorDriverPositionManagerAddress[];
    
    static const size_t mNumOfYMotorDriverBaseAddress;
    static const size_t mNumOfYMotorDriverServoAddress;
    static const size_t mNumOfYMotorDriverSupplierAddress;
    static const size_t mNumOfYMotorDriverPusherAddress;
    static const size_t mNumOfYMotorDriverShooterAddress;
    static const size_t mNumOfYMotorDriverPositionManagerAddress;
    
    YMotorDriverBase* mYMotorDriver;
    char mAddress;
};

#endif
