#include "YMotorDriver.h"
#include "YMotorDriverServo.h"
#include "YMotorDriverSupplier.h"
#include "YMotorDriverPusher.h"
#include "YMotorDriverShooter.h"

YMotorDriver* YMotorDriver::mInstance = NULL;
const PinName YMotorDriver::mAddressDeciderPinName[]  = {
    dp17, dp18, dp26, dp25
};
const char YMotorDriver::mYMotorDriverBaseAddress[] = {
    0xA0 | ( 0x01 << 1 ),
    0xA0 | ( 0x02 << 1 ),
    0xA0 | ( 0x03 << 1 )
};
const char YMotorDriver::mYMotorDriverServoAddress[] = {
    0xA0 | ( 0x04 << 1 ),
    0xA0 | ( 0x05 << 1 ),
    0xA0 | ( 0x06 << 1 ),
    0xA0 | ( 0x0D << 1 ),
    0xA0 | ( 0x08 << 1 )
};
const char YMotorDriver::mYMotorDriverShooterAddress[] = {
    0xA0 | ( 0x09 << 1 )
};
const char YMotorDriver::mYMotorDriverPusherAddress[] = {
    0xA0 | ( 0x0A << 1 )
};
const char YMotorDriver::mYMotorDriverSupplierAddress[] = {
    0xA0 | ( 0x0B << 1 )
};
const size_t YMotorDriver::mNumOfYMotorDriverBaseAddress     = 3;
const size_t YMotorDriver::mNumOfYMotorDriverServoAddress    = 5;
const size_t YMotorDriver::mNumOfYMotorDriverSupplierAddress = 1;
const size_t YMotorDriver::mNumOfYMotorDriverPusherAddress   = 1;
const size_t YMotorDriver::mNumOfYMotorDriverShooterAddress  = 1;

YMotorDriver::YMotorDriver(){
    char address = 0xA0;    // 10100000(2)
    for ( int i = 0; i < 4; ++i ){
        // 101xxxx0 --- xxxxの部分に入力データが入る
        DigitalIn d( mAddressDeciderPinName[ i ] );
        address |= d.read() << ( i + 1 );
    }
    
    // アドレスによって機能を変える
    // Motor
    for ( int i = 0; i < mNumOfYMotorDriverBaseAddress; ++i ){
        if ( address == mYMotorDriverBaseAddress[ i ] ){
            mYMotorDriver = new YMotorDriverBase( address, i );
            return;
        }
    }
    // Servo
    for ( int i = 0; i < mNumOfYMotorDriverServoAddress; ++i ){
        if ( address == mYMotorDriverServoAddress[ i ] ){
            mYMotorDriver = new YMotorDriverServo( address, i );
            return;
        }
    }
    // Supplier
    for ( int i = 0; i < mNumOfYMotorDriverSupplierAddress; ++i ){
        if ( address == mYMotorDriverSupplierAddress[ i ] ){
            mYMotorDriver = new YMotorDriverSupplier( address );
            return;
        }
    }
    // Pusher
    for ( int i = 0; i < mNumOfYMotorDriverPusherAddress; ++i ){
        if ( address == mYMotorDriverPusherAddress[ i ] ){
            mYMotorDriver = new YMotorDriverPusher( address );
            return;
        }
    }
    // Shooter
    for ( int i = 0; i < mNumOfYMotorDriverShooterAddress; ++i ){
        if ( address == mYMotorDriverShooterAddress[ i ] ){
            mYMotorDriver = new YMotorDriverShooter( address );
            return;
        }
    }
    
    // 機能が割り振られていないアドレスならLEDを点滅させておく
    DigitalOut err( dp28 );
    while ( true ){
        printf( "address:%d\r", address );
        err = 1;
        wait( 0.5f );
        err = 0;
        wait( 0.5f );
    }
}

YMotorDriver::~YMotorDriver(){
    delete mYMotorDriver;
}

void YMotorDriver::update(){
    mYMotorDriver->update();
}
