#ifndef INCLUDED_XBEE_H
#define INCLUDED_XBEE_H

#include "mbed.h"
#include "I2CDevice.h"
#include "Command.h"
#include "Steering.h"

class XBee : public I2CDevice{
public:
    XBee( char address );
    
    virtual int read();
    
    static void setAngleAdjust_deg( float angle_deg ){
        mAngleAdjust_deg = angle_deg;
    }
    static void setMoveDirection_rad( float direction_rad ){
        mMoveDirection_rad = direction_rad;
    }
    
    Command createCommand();
    
    enum AngleAdjustType{
        NO_OPERATION,
        INCREMENT,
        DECREMENT
    };
    
    enum SpeedType{
        LOW_SPEED     = 0x03,
        HIGH_SPEED    = 0x04
    };
    
    enum RollDirection{
        CONTERCLOCKWISE = 0x00,
        CLOCKWISE       = 0x01
    };
    
    static const float mAngleAdjustTable[];
    
private:
    static const size_t mNumOfDivDirection;
    static const float mDutyTable[];
    static const float mRollCoeffTable[];
    static float mAngleAdjust_deg;
    static float mMoveDirection_rad;

    float mMoveDuty;
    float mRollCoeff;
    ShootingSystem::AimState mAimState;
    Steering::ActionType mSteeringActionType;
    SpeedType mSpeedMode;
    bool mIsShooting;
    bool mIsSupplying;
    bool mIsNotStop;
    AngleAdjustType mPrevAngleAdjustType;
};

#endif