#include "mbed.h"
#include "Ultrasonic.h"

const unsigned Ultrasonic::mTimeout_us = 60000;

Ultrasonic::Ultrasonic( PinName p0 ){
    mDigitalInOut   = new DigitalInOut( p0 );
    mTimer[ 0 ] = new Timer;
    mTimer[ 1 ] = new Timer;
    
    // 音速(m/s)を音速(cm/us)に変換
    mSpeedOfSound_cm_us = 340.29f * 100.0f / ( 1000.0f * 1000.0f );
    
    mDigitalInOut->output();
    mDigitalInOut->write( 0 );
}
Ultrasonic::~Ultrasonic(){
    delete mDigitalInOut;
    delete mTimer;
}

/*
float Ultrasonic::read(){
    pulse_us( 5 );
    waitVal( 0, mTimeout );
    
    mTimer[ 0 ]->start();
    waitVal( 1, mTimeout );
    return t.read_us();
}
*/
float Ultrasonic::read_cm(){
    pulse_us( 5 );
    
    if ( waitVal( 1 ) == false ){
        return -1.0f;
    }
    
    mTimer[ 0 ]->reset();
    mTimer[ 0 ]->start();
    
    if ( waitVal( 0 ) == false ){
        return -1.0f;
    }
    
    float l = static_cast< float >( mTimer[ 0 ]->read_us() );
    l *= mSpeedOfSound_cm_us;
    l *= 0.5f;
    
    // このセンサーの測距可能距離が3cmから300cmだからその範囲に丸める
    if ( l >= 3.0f ){
        l -= 3.0f;
    } else {
        l = 0.0f;
    }
    
    if ( l > 300.0f ){
        l = 300.0f;
    }
    
    return l;
}

void Ultrasonic::pulse_us( unsigned width_us ){
    mDigitalInOut->output();
    mDigitalInOut->write( 1 );
    wait_us( width_us );
    mDigitalInOut->write( 0 );
}

bool Ultrasonic::waitVal( int val ){
    mDigitalInOut->input();
    
    mTimer[ 1 ]->reset();
    mTimer[ 1 ]->start();
    
    while ( mTimer[ 1 ]->read_us() < mTimeout_us ){
        if ( mDigitalInOut->read() == val ){
            return true;
        }
    }
    
    return false;
}
