#include <string>
#include "mbed.h"
#include "StrSerial.h"

using namespace std;

StrSerial::StrSerial( PinName tx, PinName rx, bool isEnableGets ) : RawSerial( tx, rx ){
    if ( isEnableGets ){
        mRecv       = new string;
        mTempRecv   = new string;
        
        attach( this, &StrSerial::recvIrq, RxIrq );
    } else {
        mRecv       = NULL;
        mTempRecv   = NULL;
    }
}
StrSerial::~StrSerial(){
    delete mRecv;
    delete mTempRecv;
}

void StrSerial::recvIrq(){
    char c = getc();
    
    if ( c == '\n' || c == '\r' ){
        *mTempRecv += '\0';
        *mRecv  = *mTempRecv;
        mTempRecv->erase();
    } else {
        *mTempRecv += c;
    }
}
