#ifndef INCLUDED_STR_SERIAL_H
#define INCLUDED_STR_SERIAL_H

#include "mbed.h"
#include <string>

class StrSerial : public RawSerial{
public:
    StrSerial( PinName tx, PinName rx, bool isEnableGets = true );
    ~StrSerial();
    
    const char* getsCStr(){
        return mRecv->c_str();
    }
    std::string* getsStr(){
        return mRecv;
    }
    
    void setIsEnableGets( bool isEnable ){
        if ( isEnable ){
            if ( mRecv == NULL ){
                mRecv = new std::string;
            }
            if ( mTempRecv == NULL ){
                mTempRecv = new std::string;
            }
                
            __enable_irq();
            attach( this, &StrSerial::recvIrq, RxIrq );
        } else {
            __disable_irq();
        }
    }
private:
    void recvIrq();
    
    std::string* mRecv;
    std::string* mTempRecv;
};

#endif
