#ifndef INCLUDED_STEERING_TIRE_H
#define INCLUDED_STEERING_TIRE_H

#include "Steering.h"
#include <stdint.h>
#include "mbed.h"
class Command;
class I2CMotor;

class SteeringTire{
public:
    SteeringTire( I2CMotor** tire );
    ~SteeringTire();
    void update( Steering::ActionType action, Command command );
    
private:
    void updateMove( Command command );
    void updateRoll( Command command );
    void updateStop( Command command );
    void updateWaitServo( Command command );

    static const uint32_t mReleaseStopTime_ms[];
    static const float mBrakeReleaseThreshold;
    
    I2CMotor** mTire;
    
    bool mIsReleaseStop;
    Timer* mTimer;
    Steering::ActionType mPrevActionType;
};

#endif
