#ifndef INCLUDED_STEERING_H
#define INCLUDED_STEERING_H

class Command;
class I2CMotor;
class I2CServo;
class SteeringTire;

class Steering{
public:
    enum ActionType{
        STOP        = 0x00, // 0000 0000(2)
        MOVE        = 0x08, // 0000 1000(2)
        ROLL        = 0x10, // 0001 0000(2)
        SHOOT       = 0x18, // 0001 1000(2)
        WAIT_SERVO  = 0xFF  // 通信で送られて来ることはないデータ
    };
    
    Steering( I2CMotor** t, I2CServo** s );
    ~Steering();
    
    void update( Command c );
    
    static const int mNumOfTire;
    
private:
    void updateActionType( Command command );
    void updateMove( Command command );
    void updateRoll( Command command );
    void updateStop( Command command );
    void updateWaitServo( Command command );
    
    void setServoPositionByActionType( ActionType action, Command command );
    void setServoPositionWhenMove( Command command );
    void setServoPositionWhenRoll();
    void setServoPositionWhenStop();
    
    static const float mStoppingMoveAngle;
    static const float mRollTirePosition[];
    
    SteeringTire* mTire;
    I2CServo** mServo;
    
    ActionType mActionType;
    ActionType mNextActionType;
    float mMoveDirection_rad;
};

#endif
