#ifndef SIMPLE_MAP_SERIALIZER_HPP
#define SIMPLE_MAP_SERIALIZER_HPP

#include <string>
#include <map>
#include "ValueToString.hpp"

namespace SimpleMapSerialization{
template <class T,class U>
std::string simpleMapSerializer(char delim,const std::map<T,U>& map)
{
    std::string s;
    for (typename std::map<T,U>::iterator mapIte = map.begin(); mapIte != map.end(); mapIte++) {
        T key = mapIte->first;
        U val = mapIte->second;
        std::string sKey = ConvertData::ValueToString(key) + delim;
        std::string sVal = ConvertData::ValueToString(val) + delim;
        s += sKey + sVal;
    }
    s.resize(s.size() - 1);
    return s;
}
}

#endif //SIMPLE_MAP_SERIALIZER_HPP