#ifndef INCLUDED_SHOOTING_SYSTEM_H
#define INCLUDED_SHOOTING_SYSTEM_H

class I2CServo;
class I2CMotor;
class Command;
class AmmoPusher;
class AmmoSupplier;
class AmmoSupplierManager;
class Shooter;
#include "mbed.h"

class ShootingSystem{
public:
    enum AimState{
        AIM_OWN_POLE            = 0x00,
        AIM_CENTER_MIDDLE_POLE  = 0x40,
        AIM_CENTER_SIDE_POLE    = 0x80,
        AIM_ENEMYS_POLE         = 0xC0
    };
    
    enum State{
        WAITING,
        SHOOTING,
        SHOOT_PREPARATION,
        SHOOT_WAITING,
        AMMO_SUPPLYING
    };
    
    static bool isShootable(){
        return mIsShootable;
    }
    
    ShootingSystem( I2CServo* angleManagerServo, AmmoPusher* ammoPusher,
                    AmmoSupplier* ammoSupplier, Shooter* shooter,
                    I2CServo* positoinManager );
    ~ShootingSystem();
        
    void update( Command command );
    
private:
    void waiting( Command command );
    void shooting();
    void shootWaiting();
    void shootPreparation();
    void ammoSupply();

    static bool mIsShootable;
    
    I2CServo*       mShooterAngleServo;
    AmmoPusher*     mAmmoPusher;
    AmmoSupplier*   mAmmoSupplier;
    Shooter*        mShooter;
    I2CServo*       mPositionManager;
    State mState;
    Timer mTimer;
};

#endif
