#include "Shooter.h"
#include "I2CDevice.h"

Shooter::Shooter( char address ) : I2CDevice( address ){
    mActionType = STOP;
    mLaunchType = WORKING_8V;
}

void Shooter::launch(){
    setActionType( mLaunchType );
}

void Shooter::stop(){
    setActionType( STOP );
}

int Shooter::write(){
    char buf = mActionType;
    return I2CDevice::write( &buf, 1 );
}
