#ifndef INCLUDED_SHOOTER_H
#define INCLUDED_SHOOTER_H

#include "I2CDevice.h"

class Shooter : public I2CDevice{
public:
    enum ActionType{
        STOP        = 0x00, // 0000(2)
        WORKING_8V  = 0x01, // 0001(2)
        WORKING_12V = 0x03, // 0011(2)
        WORKING_16V = 0x07, // 0111(2)
        WORKING_20V = 0x0F  // 1111(2)
    };
    
    Shooter( char address );
    
    void setVoltage( ActionType action ){
        setLaunchType( action );
        
        if ( mActionType != STOP ){
            setActionType( mLaunchType );
        }
    }
    void setActionType( ActionType action ){
        mActionType = action;
    }
    void setLaunchType( ActionType action ){
        mLaunchType = action;
    }
    void launch();
    void stop();
    bool isWorking(){
        return ( mActionType != STOP );
    }
    
    ActionType getVoltage(){
        return mActionType;
    }
    
protected:
    virtual int write();

private:
    ActionType mActionType;
    ActionType mLaunchType;
};

#endif
